/**
 * @module 1-liners/assign
 *
 * @description
 *
 * Returns a new object and assigns `assign` to `object`.
 *
 * @example
 *
 * 	const assign = require('1-liners/assign');
 *
 * 	const yedi = { id: 1, age: 100 };
 *
 * 	assign({ name: 'Yoda', age: 900 }, yedi);  // => { id: 1, name: 'Yoda', age:900 }
 *
 */
"use strict";

exports.__esModule = true;
// istanbul ignore next

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports["default"] = function (assign, object) {
  return _extends({}, object, assign);
};

module.exports = exports["default"];