//定义个人的信息窗体
import { Modal } from "antd";
const { confirm } = Modal;
export default function (data) {
  const {
    name,
    com,
    idCardNo,
    attendancePoints,
    perId,
    photoUrl,
    comName,
    mobilePhone,
  } = data;
  var content = [];
  const imgHeader = [];
  if (photoUrl) {
    imgHeader.push("<img src=" + photoUrl + ">");
  } else {
    imgHeader.push(
      "<span class='img-span'>" +
        name.substring(name.length - 2, name.length) +
        "</span>"
    );
  }
  if (comName) {
    content.push(
      "<div><div class='image'>" +
        imgHeader +
        "</div><div class='content-text'><div class='text'>" +
        name +
        "</div><div class='text'>手机号码：" +
        mobilePhone +
        "</div><div class='text'>证件号码：" +
        idCardNo +
        "</div><div class='text'>所属企业：" +
        comName +
        "</div></div>"
    );
  } else {
    content.push(
      "<div><div class='image'>" +
        imgHeader +
        "</div><div class='content-text'><div class='text'>" +
        name +
        "</div><div class='text'>手机号码：" +
        mobilePhone +
        "</div><div class='text'>证件号码：" +
        idCardNo +
        "</div></div>"
    );
  }
  content.join("<br/>");
  var info = document.createElement("div");
  info.className = "content-window-card";
  //可以通过下面的方式修改自定义窗体的宽高
  info.style.width = "400px";
  // 定义内容
  var middle = document.createElement("div");
  middle.className = "info-middle";
  middle.innerHTML = content;
  info.appendChild(middle);
  //定义详情
  var detail = document.createElement("div");
  detail.className = "detail-div";
  info.appendChild(detail);
  //定义关闭按钮
  var detail = document.createElement("div");
  detail.className = "close-div";
  var a = document.createElement("a");
  a.innerHTML = "x";
  // a.style.marginLeft = '95px';
  a.onclick = () => {
    // this.state.map.clearInfoWindow();
    this.clear("setPersonSelectIndex");
  };
  detail.appendChild(a);
  info.appendChild(detail);
  //定义三个调度按钮
  var top = document.createElement("div");
  top.className = "info-button";
  var button1 = document.createElement("span");
  button1.className = "button";
  button1.innerHTML = "文字调度";
  button1.onclick = () => {
    this.clear("setPersonSelectIndex");
    this.character(data);
  };
  var button2 = document.createElement("span");
  button2.className = "button";
  button2.innerHTML = "语音调度";
  button2.onclick = () => {
    this.clear("setPersonSelectIndex");
    this.voice(data);
  };
  var button3 = document.createElement("span");
  button3.className = "button";
  button3.innerHTML = "视频调度";
  button3.onclick = () => {
    this.clear("setPersonSelectIndex");
    const _this = this;
    confirm({
      // title: "是否立即启动调度?",
      title: "是否开启屏幕录制?",
      content:
        "开启后，被调度保安员的视频页面将会被录制，调度结束后，可查看录制文件。",
      okText: "开启录制,继续调度",
      cancelText: "不开启录制,继续调度",
      onOk() {
        _this.video([data], "个人调度", [mobilePhone]);
      },
      onCancel() {
        _this.video([data], "个人调度",[]);
      },
    });
  };
  top.appendChild(button1);
  top.appendChild(button2);
  top.appendChild(button3);
  info.appendChild(top);
  // 定义底部内容
  var bottom = document.createElement("div");
  bottom.className = "info-bottom";
  bottom.style.position = "relative";
  bottom.style.top = "-1px";
  bottom.style.margin = "0 auto";
  var sharp = document.createElement("img");
  sharp.src = "https://webapi.amap.com/images/sharp.png";
  bottom.appendChild(sharp);
  info.appendChild(bottom);
  return info;
}
