/**
 * 地图页面
 */
import React, { PureComponent } from "react";
import style from "styled-components";
import CreateInfoWindow from '../mapModule/messageWindow/CreateInfoWindow';
import CreateAttenInfoWindow from "../mapModule/messageWindow/CreateAttenInfoWindow";
import { connect } from "dva";
import "../../Command/command.less";
import TIM from "tim-js-sdk";
import tim from "../../../utils/imInitialize";
import {
  createGroup,
  sendVideoRoomMsg,
  policeGetPerLocationPageList,
  policeGetTaskLocationList,
} from "../../../services/api";
import {
  message,
  Button,
  Modal,
  Input,
  Form,
  Row,
  Col,
  Icon,
  Switch,
} from "antd";
import IM from "../../Command/IM/index";
import Video from "../../Command/Video/index";
import Vectorgraph from "../../Command/mapModule/Vectorgraph";
import Record from "../../Command/Record/index";
import SwitchMap from "../mapModule/SwitchMap";
import BeijingVideo from "../../Command/mapModule/BeijingVideo";
import store1 from "../../../../src/index";
import { routerRedux } from "dva/router";
import SearchListTab from "./SearchListTab";
import loadMap from "../../Command/mapModule/loadMap";
import InitMap from "../mapModule/InitMap";
import ModalView from "../mapModule/ModalView";
import {
  markPersonList,
  openPersonInfo,
  closePersonMarkers,
  markerAttendanceList,
  openAttendanceInfo,
  closeAttendanceMarker,
  massAttendancePoint,
  massPersonPoint
} from "../mapModule/markMarkers";
// import PersonSearch from '../../Command/GIS/Person/PersonSearch'
const { TextArea } = Input;

@connect((state) => ({
  //im
  mobilePhone: state.user.currentUser.mobilePhone,
  imSig: state.global.imSig,
  imIsLogin: state.global.imIsLogin,
  comName: state.global.companyInfo.comName,
  nextReqMessageID: state.im.nextReqMessageID,
  conversationList: state.im.conversationList,
  currentMessageList: state.im.currentMessageList,

  //地图数据
  attendanceList: state.command.attendanceList,
  personList: state.command.personList,
  clearInfoWindow: state.command.clearInfoWindow,
  tabIndex1: state.command.tabIndex.tabIndex1,
}))
@Form.create()
export default class GIS extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      mouseTool: null,
      //地图部门功能全局化
      map: null,
      mass: null,
      //驻勤点图层
      attenPersonList: [], //驻勤点下的人员列表
      attenPersonMarkers: [], //驻勤点下的人员的数据
      attendanceMarkers: [], //驻勤点的数据
      //人员图层
      personMarkers: [], //人员打点
      personList: [], //人员数据

      infoWindow: null, //全局定义信息窗体（在初始化地图的时候，也初始化信息窗体）
      imStatus: false, //是否展示im的可视化页面
      videoStatus: false, //视频通话页面是否显示

      selectedPoints: [], //通过矢量图选中的多个数据点
      overlays: [], //矢量图绘制的点（主要用在清空矢量图）
      selectedPointsStatus: false, //显示选中多人数据的弹窗
      selectedData: {
        phone: "",
      }, //选中的点的数据
      //调度的内容
      dispatchType: "", //调度类型（text文字,voice语音,video视频）
      createTaskStatus: false, //创建任务弹窗状态
      schedulingContent: "", //调度任务内容
      schedulingName: "", //调度任务名称
      recordMobile: "", //调度需要录制视频的人员
      needCreateConversation: false, //是否需要创建单人会话
      layerSatatus: "attendance", //海量点图层(attendance是驻勤点图层，mass是海量图层,person是人员图层)
      normalMap: null, //正常的图层（变成是驻勤点图层）
      locaMap: null, //海量图层
      massDataTotalPage: 0, //海量点的总页数
      allData: [], //全部的海量点数据
      searchData: {
        pageNumber: 1,
        pageSize: 7,
        keyWord: null,
      },
      paintValue: "cancel", //选中的是用哪个图形画图
      conversationID: "", //当前在地图中选中的哪个人或群组的id
      //录音
      showRecord: false, //是否显示录音的页面
      spinLoading: false, //全局加载状态
      onlyPersonVoiceStatus: false, //个人调度的录音状态

      hasLayerSatatus: false, //是否已经加载过海量点的数据（默认还没加载）
      hasLayerAttendanceMassSatatus: false, //是否已经加载过驻勤点海量点的数据（默认还没加载）
      allAttendanceList: [], //所有驻勤点信息
      allPersonList: [], //所有人员信息
      zoom: 18, //点击某个点，然后放大图层
      currentTabKey1: "2", //当前选中的tab页面
      afterAttenSelectedId:null,//过去驻勤点选中的值,默认没有
    };
  }

  /******************************生命周期******************************/
  componentDidMount() {
    // if (document.querySelector(".ant-layout-header")) {
    //   // 隐藏左侧菜单栏
    //   document.querySelector(".ant-layout-sider").style.display = "none";
    //   document.querySelector(".ant-layout-content").style.margin = "0px";
    //   document.querySelector(".oneKeySearchHidden").style.display = "none";
    //   //隐藏顶部菜单栏
    //   document.querySelector(".ant-layout-header").style.display = "none";
    // }

    loadMap.call(this); //加载地图组件
    tim.on(TIM.EVENT.KICKED_OUT, () => {
      console.log("被剔出");
      const { dispatch } = store1;
      dispatch(routerRedux.push("/user/logOn"));
    });
  }
  componentWillReceiveProps(nextProps) {
    //要先让地图加载完在判断
    if (this.state.map) {
      /**
       * 人员信息
       */
      const nextPropsPersonSelectedId = nextProps.personList.selectedId;
      const nextPropsPersonList = nextProps.personList.list;
      if (
        JSON.stringify(nextPropsPersonList) !==
        JSON.stringify(this.state.allPersonList)
      ) {
        this.setState({
          allPersonList: nextPropsPersonList,
        });
        this.markPersonList(nextPropsPersonList);
      }
      //点击点改变点的状态
      if (this.state.personMarkers.length > 0 && nextPropsPersonSelectedId) {
        this.state.personMarkers.map((marker) => {
          if (marker.w.key === nextPropsPersonSelectedId) {
            nextPropsPersonList.forEach((item) => {
              if (item.perId == marker.w.key) {
                this.openPersonInfo(item, this.state.map, marker);
              }
            });
          }
        });
      }
      /**
       * 驻勤点
       */
      //所有驻勤点有值，并且更换的时候，打点，
      const nextPropsAttenSelectedId = nextProps.attendanceList.selectedId;
      const nextPropsAttendanceList = nextProps.attendanceList.list;
      if (
        JSON.stringify(nextPropsAttendanceList) !==
        JSON.stringify(this.state.allAttendanceList)
      ) {
        this.setState({
          allAttendanceList: nextPropsAttendanceList,
        });
        this.markerAttendanceList(nextPropsAttendanceList);
      }
      //点击点改变点的状态
      if (this.state.attendanceMarkers.length > 0 && nextPropsAttenSelectedId!=null) {
        // this.state.attendanceMarkers.map((marker) => {
        //   if (marker.w.comTaskId === nextPropsAttenSelectedId) {
        //     nextPropsAttendanceList.forEach((item) => {
        //       if (item.comTaskId == marker.w.comTaskId) {
        //         this.openAttendanceInfo(item, this.state.map, marker);
        //       }
        //     });
        //   }
        // });
        this.openAttendanceInfo(nextPropsAttendanceList[nextPropsAttenSelectedId], this.state.map, this.state.attendanceMarkers[nextPropsAttenSelectedId],nextPropsAttenSelectedId,this.state.afterAttenSelectedId);
        this.setState({
          afterAttenSelectedId:nextPropsAttenSelectedId
        })
      }
      //清除地图上的信息窗体
      if (nextProps.clearInfoWindow) {
        this.state.map.clearInfoWindow();
        this.props.dispatch({
          type: "command/clearInfoWindow",
          payload: false,
        });
        closePersonMarkers.call(this);
        closeAttendanceMarker.call(this);
        this.setState({
          afterAttenSelectedId:null
        })
      }
      //Tab改变
      if (this.state.currentTabKey1 != nextProps.tabIndex1) {
        const tabKey = [
          {
            key: "1",
            marker: "",
          },
          {
            key: "2",
            marker: "person",
          },
          {
            key: "3",
            marker: "attendance",
          },
        ];
        this.setState({
          currentTabKey1: nextProps.tabIndex1,
        });
        let current = null;
        let past = null;
        tabKey.map((item) => {
          if (item.key == nextProps.tabIndex1) {
            current = item.marker;
          }
          if (item.key == this.state.currentTabKey1) {
            past = item.marker;
          }
        });
        this.clearMarkerAdd(current, past);
      }
    }
  }
  componentWillUnmount() {
    if (document.querySelector(".ant-layout-sider")) {
      // 显示左侧菜单栏
      document.querySelector(".ant-layout-sider").style.display = "block";
      document.querySelector(".ant-layout-content").style.margin = "16px";
      document.querySelector(".oneKeySearchHidden").style.display = "block";
    }
    window.AMap = null;
  }
  initialMap = () => {
    const mapList = InitMap.call(this);
    const normalMap = mapList.normalMap;
    const locaMap = mapList.locaMap;
    const infoWindow = mapList.infoWindow;
    const personMap = mapList.personMap;
    this.setState({
      normalMap,
      locaMap,
      personMap,
      map: normalMap,
      infoWindow,
    });
    //创建矢量图画图工具
    this.createMouseTool(this.state.map);
    //检查im有没有失效
    if (!!!this.props.imIsLogin) {
      console.log("重新请求");
      console.log(this.props.mobilePhone);
      if (this.props.mobilePhone) {
        this.props.dispatch({
          type: `global/imLogin`,
          payload: {
            username: this.props.mobilePhone,
          },
        });
      }
    }
  };
  //创建矢量图画图工具
  createMouseTool(currentMap) {
    const { AMap } = window;
    AMap.plugin(["AMap.MouseTool", "AMap.PlaceSearch"], () => {
      const mouseTool = new AMap.MouseTool(currentMap);
      this.setState({
        mouseTool,
      });
      //添加事件
      AMap.event.addListener(mouseTool, "draw", (e) => {
        this.setState({
          overlays: e.obj,
        });
        let polygonPoints = e.obj.getPath();
        // 整理多边形点的数据 变成[[],[]]的格式
        polygonPoints.map((point) => {
          return [point.lng, point.lat];
        });
        let selectedPoints = null;
        if (this.state.layerSatatus === "attendance") {
          //正常图层的时候
          selectedPoints = this.props.personList.list.filter((pos) => {
            //取的数据是该驻勤点下的人员数据
            if (pos.lnglat) {
              // 地图点的坐标转换成[]
              const posArray = [pos.lnglat[0], pos.lnglat[1]];
              return AMap.GeometryUtil.isPointInRing(posArray, polygonPoints);
            }
          });
        } else if (this.state.layerSatatus === "mass") {
          console.log(this.state.allData)
          //海量图层
          selectedPoints = this.state.allData.filter((pos) => {
            console.log(pos)
            if (pos.lnglat) {
              // 地图点的坐标转换成[]
              // const posArray = [pos.lnglat.lng, pos.lnglat.lat];
              return AMap.GeometryUtil.isPointInRing(pos.lnglat, polygonPoints);
            }
          });
        } else if (this.state.layerSatatus === "person") {
          selectedPoints = this.state.personList.filter((pos) => {
            if (pos.lnglat) {
              // 地图点的坐标转换成[]
              const posArray = [pos.lnglat[0], pos.lnglat[1]];
              return AMap.GeometryUtil.isPointInRing(posArray, polygonPoints);
            }
          });
        }
        if (selectedPoints.length === 0) {
          Modal.error({
            title: "没有选中项",
            onOk: () => {
              this.state.map.remove([e.obj]);
            },
          });
        } else {
          this.setState({
            selectedPoints,
            selectedPointsStatus: true,
          });
        }
      });
      // new AMap.PlaceSearch({});
      let placeSearch = new AMap.PlaceSearch({
        pageSize: 6, // 单页显示结果条数
        pageIndex: 1, // 页码
        city: "010", // 兴趣点城市
        citylimit: true, //是否强制限制在设置的城市内搜索
        map: this.state.map, // 展现结果的地图实例
        panel: "panel", // 结果列表将在此容器中进行展示。
        autoFitView: true, // 是否自动调整地图视野使绘制的 Marker点都处于视口的可见范围
      });
      this.setState({ placeSearch });
      // 关键字查询
      //  placeSearch.search('厦门市软件园三期');
    });
  }
  //初始海量数据(人员)
  massPoints(pageNumber, pageSize, locaMap) {
    //真正的海量图搜索
    policeGetPerLocationPageList({ pageNumber, pageSize }).then((res) => {
      const data = this.state.allData;
      data.push(...res.data.data);
      this.setState({
        massDataTotalPage: res.data.totalPage,
        allData: data,
      });
      if (res.retType === "0" && res.data.total > 0) {
        // let style = [
        //   {
        //     //0是圆圈
        //     url: "https://a.amap.com/jsapi_demos/static/images/mass1.png",
        //     anchor: new AMap.Pixel(0, 0),
        //     size: new AMap.Size(2, 2),
        //   },
        // ];
        // let mass = new AMap.MassMarks(res.data.data, {
        //   opacity: 0.8,
        //   zIndex: 111,
        //   cursor: "pointer",
        //   style: style,
        // });
        // this.setState({ ["mass" + pageNumber]: mass });
        // const that = this;
        // mass.on("click", function (e) {
        //   let infoWindow = new AMap.InfoWindow({
        //     isCustom: true, //使用自定义窗体
        //     content: that.createInfoWindow(e.data),
        //     offset: new AMap.Pixel(16, -45),
        //   });
        //   infoWindow.open(locaMap, e.data.lnglat);
        // });
        // mass.setMap(locaMap);
        const nextPageNumber = pageNumber + 1;
        if (
          nextPageNumber < res.data.totalPage ||
          nextPageNumber === res.data.totalPage
        ) {
          this.massPoints(nextPageNumber, pageSize, locaMap);
        }else{
          //数据请求完，在渲染所有数据
          massPersonPoint.call(this,this.state.allData)
        }
      }
    });
  }
  //初始化所有驻勤点数据
  massAttendancePoints(pageNumber, pageSize, locaMap) {
    //真正的海量图搜索
    policeGetTaskLocationList({ pageNumber, pageSize }).then((res) => {
      if (res.retType === "0" && res.data.total > 0) {
        massAttendancePoint.call(this, res.data.data);
        const nextPageNumber = pageNumber + 1;
        if (
          nextPageNumber < res.data.totalPage ||
          nextPageNumber === res.data.totalPage
        ) {
          this.massAttendancePoints(nextPageNumber, pageSize, locaMap);
        }
      }
    });
  }
  //切换图层
  switchMap(value) {
    this.state.mouseTool.close(true);
    this.state.map.clearInfoWindow();
    this.setState({
      paintValue: "cancel",
    });
    if (value !== this.state.layerSatatus) {
      //有切换的时候才进行数据的处理
      //如果是切换地图的
      this.setState({ searchList: [] });
      switch (true) {
        case value === "attendance":
          //换成驻勤点图
          this.setState({
            layerSatatus: value,
            map: this.state.normalMap,
          });
          document.querySelector(".vectorgraph").style.display = "block";
          document.querySelector(".radio_container-open").style.display = "block";
          //创建矢量图画图工具
          this.createMouseTool(this.state.normalMap);
          break;
        case value === "mass":
          //保安员分布态势
          if (!this.state.hasLayerSatatus) {
            //初始化海量点数据
            const pageNumber = 1,
              pageSize = 100000;
            this.massPoints(pageNumber, pageSize, this.state.locaMap);
          }
          //换成海量图层
          this.setState({
            layerSatatus: value,
            map: this.state.locaMap,
            hasLayerSatatus: true,
          });
          //设置中心点是北京
          const position2 = new AMap.LngLat(116.344081, 39.940512);
          this.state.locaMap.setCenter(position2);
          document.querySelector(".vectorgraph").style.display = "none";
          document.querySelector(".radio_container-open").style.display = "block";
          this.setState({imStatus:false})
          //创建矢量图画图工具
          this.createMouseTool(this.state.locaMap);
          break;
        case value === "person":
          //驻勤点分布态势
          if (!this.state.hasLayerAttendanceMassSatatus) {
            //初始化驻勤点海量点数据
            const pageNumber = 1,
              pageSize = 100000;
            this.massAttendancePoints(
              pageNumber,
              pageSize,
              this.state.personMap
            );
          }
          //设置中心点是北京
          const position = new AMap.LngLat(116.344081, 39.940512);
          this.state.personMap.setCenter(position);
          document.querySelector(".vectorgraph").style.display = "none";
          document.querySelector(".radio_container-open").style.display = "none";
          this.setState({imStatus:false})
          this.setState({
            layerSatatus: value,
            map: this.state.personMap,
            hasLayerAttendanceMassSatatus: true,
          });
          break;
      }
    }
  }
  //人员图层对搜索出的人员打点
  markPersonList(personList, where = "") {
    const personMarkers = markPersonList.call(this, personList, where);
    this.setState({ personMarkers });
  }
  //人员的打点更换
  openPersonInfo(item, map, marker) {
    const markers = openPersonInfo.call(this, item, map, marker);
    // this.setState({
    //   personMarkers: markers,
    // });
  }
  //切换打点是否跳动动画
  changePersonMarker(item, map, marker) {
    const markers = this.state.personMarkers;
    if (item) {
      markers.map((itemMark, i) => {
        if (itemMark.w.key === item.perId) {
          markers[i].setAnimation("AMAP_ANIMATION_BOUNCE");
        } else {
          markers[i].setAnimation("AMAP_ANIMATION_NONE");
        }
      });
      this.setState({
        personMarkers: markers,
      });
      this.state.map.setCenter(marker.getPosition());
    } else {
      markers.map((itemMark, i) => {
        markers[i].setAnimation("AMAP_ANIMATION_NONE");
      });
    }
  }
  //搜索出的驻勤点打点
  markerAttendanceList(attendanceList, typeName = "") {
    const attendanceMarkers = markerAttendanceList.call(
      this,
      attendanceList,
      typeName
    );
    this.setState({ attendanceMarkers });
  }
  //驻勤点的打点更换
  openAttendanceInfo(item, map, marker,currentIndex,afterIndex) {
    const markers = openAttendanceInfo.call(this, item, map, marker,currentIndex,afterIndex);
    //这里会导致类查询，先点开一个类型，点击该类型的一个驻勤点，在打开其他类型。所有的驻勤点值还是只有第一个打开的类型的驻勤点数量
    // this.setState({
    //   attendanceMarkers: markers,
    // });
  }
  //定义单个的人员信息窗体
  createInfoWindow(data) {
    return CreateInfoWindow.call(this, data);
  }
  //驻勤点的信息窗体
  createAttendanceInfoWindow(data) {
    return CreateAttenInfoWindow.call(this, data);
  }
  //清空点击数据
  clear(clearType) {
    //清空人员的点击数据
    this.props.dispatch({
      type: "command/" + clearType,
      payload: null,
    });
    this.props.dispatch({
      type: "command/clearInfoWindow",
      payload: true,
    });
  }
  //清空不是本tab下的驻勤点，并且打上自己原本有的驻勤点
  clearMarkerAdd(current, past) {
    if (this.state[past + "Markers"]) {
      //清空不属于自己tab下的驻勤点
      this.state.map.remove(this.state[past + "Markers"]);
    }
    if (this.state[current + "Markers"]) {
      this.state.map.add(this.state[current + "Markers"]);
    }
  }
  //视频调度（单人与多人）
  video(info = [], schedulingName = "个人调度", isNeedRecord = []) {
    console.log(isNeedRecord);
    //输入人员信息，调度名称
    const Members = [];
    info.map((item) => {
      Members.push(item.mobilePhone);
    });
    const Room_No = Math.round(new Date() / 1000);
    this.setState({
      Room_No,
      MemberList: Members.join(","),
    });
    sendVideoRoomMsg({
      Room_No, //房间号
      MemberList: Members.join(","), //所有调度成员
      Yardman_Name: this.props.comName, //本人的公司名
      Yardman_Task_Name: schedulingName, //调度任务名称
      Yardman_Task_Explain: "", //调度任务说明(视频的时候不用填)
      transcribeMobiles: isNeedRecord ? isNeedRecord.join(",") : "", //需要录制的人员手机号
    }).then((res) => {
      if (res.retType === "0") {
        this.state.map.clearInfoWindow();
        this.setState({
          createTaskStatus: false, //关掉任务创建页面
          videoStatus: true, //把视频页面打开
          // isNeedRecord,
        });
      }
    });
  }
  //文字调度事件（单人）
  character(info) {
    //添加会话（单人对单人）
    tim.getConversationProfile(`C2C${info.mobilePhone}`).then(
      ({ data }) => {
        // 3.1 更新当前会话
        this.props.dispatch({
          type: `im/updateCurrentConversation`,
          payload: data.conversation,
        });
        this.setState({
          conversationID: `C2C${info.mobilePhone}`,
          imStatus: true,
          selectedData: info, //这个会把搜索列表的红标记去掉
          needCreateConversation: true,
        });
        // 3.2 获取消息列表
        this.getMessageList(data.conversation.conversationID);
        return Promise.resolve();
      },
      (err) => {
        // message.error(err.toString());
      }
    );
    this.state.map.clearInfoWindow();
  }
  //文字调度（多人，先创建群组）
  createGroup() {
    const Members = [];
    const memberList = [];
    Members.push(this.props.adminPhone + "admin");
    this.state.selectedPoints.map((item) => {
      Members.push(item.mobilePhone);
      memberList.push({
        userID: item.mobilePhone + "",
      });
    });
    let options = {
      name: this.state.schedulingName,
      type: TIM.TYPES.GRP_PRIVATE,
      memberList,
    };
    tim
      .createGroup(options)
      .then((info) => {
        //创建成功之后，往里面发送一条消息
        this.sendTextMessage(info.data.group.groupID);
        this.setState({ selectedPointsStatus: false }); //关闭调度的窗口
      })
      .catch((err) => {
        console.log(err);
      });
  }
  //语音调度（单人）单人的就是打开会话，然后调用录音
  voice(data) {
    this.setState({
      onlyPersonVoiceStatus: true,
      selectedData: data,
    });
    this.state.map.clearInfoWindow();
  }
  //语音调度（多人）,//先创建一个群，录完音，在这个会话中发送该录音
  voiceGroup(url, time) {
    const memberList = [];
    this.state.selectedPoints.map((item) => {
      memberList.push({
        userID: item.mobilePhone + "",
      });
    });
    let options = {
      name: this.state.schedulingName,
      type: TIM.TYPES.GRP_PRIVATE,
      memberList,
    };
    tim
      .createGroup(options)
      .then((info) => {
        //创建成功之后，往里面发送一条消息
        this.sendCustomMessage(
          info.data.group.groupID,
          url,
          time,
          TIM.TYPES.CONV_GROUP
        );
        this.state.map.remove([this.state.overlays]);
        this.state.map.clearInfoWindow();
        this.setState({ showRecord: false, selectedPointsStatus: false });
      })
      .catch((err) => {
        console.log(err);
      });
  }
  //发送文字消息
  sendTextMessage(groupID) {
    const messageData = tim.createTextMessage({
      to: groupID,
      conversationType: TIM.TYPES.CONV_GROUP, //群组调度
      payload: { text: this.state.schedulingContent },
    });
    tim
      .sendMessage(messageData)
      .then((res) => {
        //获取当前的会话
        this.getCurrentConvarsation(groupID);
      })
      .catch((err) => {
        message.error("发送失败");
      });
  }
  //发送自定义消息
  sendCustomMessage(groupID, url, time, type) {
    const content = {
      url,
      time,
    };
    const messageSound = tim.createCustomMessage({
      to: groupID,
      conversationType: type,
      payload: {
        data: "Sound", // 用于标识该消息是音频类型消息
        description: "[语音]", // 获取音频路径
        extension: JSON.stringify(content),
      },
    });
    tim
      .sendMessage(messageSound)
      .then((res) => {
        if (type === TIM.TYPES.CONV_GROUP) {
          //获取群组当前的会话
          this.getCurrentConvarsation(groupID);
        } else {
          //获取个人当前的会话
          this.getMessageList(res.data.message.conversationID);
        }
      })
      .catch((err) => {
        message.error("发送失败");
      });
  }
  //获取当前的会话
  getCurrentConvarsation(groupID) {
    tim.getConversationProfile(`GROUP${groupID}`).then(({ data }) => {
      // 3.1 更新当前会话
      this.props.dispatch({
        type: `im/updateCurrentConversation`,
        payload: data.conversation,
      });
      this.setState({
        createTaskStatus: false,
        imStatus: true,
        conversationID: "GROUP" + groupID,
      }); //打开im的会话框
      // 3.2 获取消息列表
      this.getMessageList(data.conversation.conversationID);
      return Promise.resolve();
    });
  }
  //获取当前会话的消息列表
  getMessageList(conversationID) {
    const { nextReqMessageID, currentMessageList } = this.props;
    tim
      .getMessageList({ conversationID, nextReqMessageID, count: 15 })
      .then((imReponse) => {
        // 更新messageID，续拉时要用到
        this.props.dispatch({
          type: "im/updateCurrentConversationCont",
          payload: {
            nextReqMessageID: imReponse.data.nextReqMessageID,
            isCompleted: imReponse.data.isCompleted,
            currentMessageList: [
              ...imReponse.data.messageList,
              ...currentMessageList,
            ], // 更新当前消息列表，从头部插入
          },
        });
      });
  }

  /******************************相关事件******************************/
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Container className="lalal" key="GIS">
        {/* 驻勤点图层 */}
        <div
          style={{
            width: innerWidth,
            // height: 'calc(100vh - 72px)',
            // height: "calc(100vh)",
            height: "100%",
            display:
              this.state.layerSatatus === "attendance" ? "block" : "none",
          }}
          className="App"
          id="map_container"
        ></div>
        {/* 海量图图层 */}
        <div
          style={{
            width: innerWidth,
            // height: "calc(100vh)",
            height: "100%",
            display: this.state.layerSatatus === "mass" ? "block" : "none",
          }}
          className="App"
          id="map_container2"
        ></div>
        {/* 人员图层 */}
        <div
          style={{
            width: innerWidth,
            height: "calc(100vh)",
            display: this.state.layerSatatus === "person" ? "block" : "none",
          }}
          className="App"
          id="map_container3"
        ></div>
        <div>
          {/* 基础信息的搜索框 */}
          {this.state.map && this.state.layerSatatus == "attendance" && (
            <SearchListTab
              //调度处理
              clickTextScheduling={(item, type, isNeedRecord = []) => {
                switch (type) {
                  case "text":
                    this.character(item);
                    break;
                  case "voice":
                    this.voice(item);
                    break;
                  case "video":
                    const dataType = Object.prototype.toString.call(item);
                    if (dataType == "[object Array]") {
                      this.video(item, "个人调度", [isNeedRecord]);
                    } else if (dataType == "[object Object]") {
                      this.video([item], "个人调度", [isNeedRecord]);
                    } else {
                      console.log("数据出错");
                    }
                    break;
                }
              }}
              changeImStatus={(value) => {
                this.setState({
                  imStatus: value,
                });
              }}
              //群组里的视频调度，获取多人的调度逻辑
              groupVideo={(list) => {
                this.setState({
                  createTaskStatus: true,
                  selectedPoints: list,
                  dispatchType: "video",
                });
              }}
            />
          )}
          {/* 绘制矢量图 */}
          <Vectorgraph
            changeSelect={(e) => {
              this.setState({
                paintValue: e,
              });
              this.state.map.clearInfoWindow();
              switch (e) {
                case "circle":
                  this.state.mouseTool.circle({
                    fillColor: "#00b0ff",
                    strokeColor: "#80d8ff",
                  });
                  break;
                case "rectangle":
                  this.state.mouseTool.rectangle({
                    fillColor: "#00b0ff",
                    strokeColor: "#80d8ff",
                  });
                  break;
                case "polygon":
                  this.state.mouseTool.polygon({
                    fillColor: "#00b0ff",
                    strokeColor: "#80d8ff",
                  });
                  break;
                case "cancel":
                  this.state.mouseTool.close(true);
                  break;
              }
            }}
            paintValue={this.state.paintValue}
          />
          {/* 打开会话按钮 */}
          <div className="radio_container-open">
            <Icon
              className="icon-fold"
              type={this.state.imStatus ? "menu-unfold" : "menu-fold"}
              onClick={() => {
                this.setState({ imStatus: !this.state.imStatus });
                this.state.map.clearInfoWindow();
              }}
              style={{ fontSize: "30px", color: "#4285EC" }}
            />
          </div>
          {/* 地图切换 */}
          <SwitchMap
            layerSatatus={this.state.layerSatatus}
            switchMap={(value) => {
              this.switchMap(value);
            }}
          />
          {/* 调度人数确认 */}
          <Modal
            className="selected-points-modal"
            // title="调度"
            visible={this.state.selectedPointsStatus}
            onOk={this.handleOk}
            onCancel={() => {
              this.setState({ selectedPointsStatus: false });
              this.state.map.remove([this.state.overlays]);
            }}
            footer={[
              <span style={{ float: "left" }} key="number">
                共选中{this.state.selectedPoints.length}人
              </span>,
              <Button
                key="text"
                type="primary"
                onClick={() => {
                  const that = this;
                  //超过50人
                  if (
                    this.state.selectedPoints.length > 50 &&
                    this.state.selectedPoints.length < 100
                  ) {
                    Modal.confirm({
                      title: "提示",
                      content:
                        "您调度人员已经超过50人，建议减少人数已达到调度效果。",
                      okText: "继续调度",
                      onOk() {
                        that.setState({
                          selectedPointsStatus: false,
                          createTaskStatus: true,
                        });
                      },
                      cancelText: "重新选择",
                      onCancel() {
                        that.setState({ selectedPointsStatus: false });
                        that.state.map.remove([that.state.overlays]);
                      },
                    });
                  } else if (this.state.selectedPoints.length > 100) {
                    Modal.error({
                      title: "提示",
                      content:
                        "您调度人员已经超过100人，请减少人数已达到调度效果。",
                      okText: "重新选择",
                      onOk() {
                        that.setState({ selectedPointsStatus: false });
                        that.state.map.remove([that.state.overlays]);
                      },
                    });
                  } else {
                    this.setState({
                      selectedPointsStatus: false,
                      createTaskStatus: true,
                      dispatchType: "text",
                    });
                  }
                }}
              >
                文字调度
              </Button>,
              <Button
                key="voice"
                type="primary"
                onClick={() => {
                  this.setState({
                    dispatchType: "voice",
                    selectedPointsStatus: false,
                    createTaskStatus: true,
                  });
                }}
              >
                语音调度
              </Button>,
              <Button
                key="video"
                type="primary"
                onClick={() => {
                  this.setState({
                    dispatchType: "video",
                    selectedPointsStatus: false,
                    createTaskStatus: true,
                  });
                }}
              >
                视频调度
              </Button>,
            ]}
          >
            <div>
              <Row gutter={24}>
                {this.state.selectedPoints.map((item, index) => {
                  return (
                    <Col span={12} key={index}>
                      <div
                        className="content-window-card"
                        style={{ marginBottom: 10 }}
                      >
                        <div className="info-middle">
                          {item.photoUrl ? (
                            <img className="avator" src={item.photoUrl}></img>
                          ) : (
                            <span className="avator span-header">
                              {item.name
                                ? item.name.substring(
                                    item.name.length - 2,
                                    item.name.length
                                  )
                                : ""}
                            </span>
                          )}
                          <div className="text" style={{whiteSpace:'nowrap',overflow:'hidden'}}>
                            <div className="name">{item.name}</div>
                            <div>手机号：{item.mobilePhone}</div>
                            <div>证件号码：{item.idCardNo}</div>
                            <div>所属企业：{item.comName}</div>
                          </div>
                        </div>
                      </div>
                    </Col>
                  );
                })}
              </Row>
            </div>
          </Modal>
          {/* 调度任务创建 */}
          <Modal
            className="create-task-modal"
            visible={this.state.createTaskStatus}
            onOk={this.handleOk}
            onCancel={() => {
              this.setState({ createTaskStatus: false });
              this.state.map.remove([this.state.overlays]);
            }}
            footer={
              //语音调度的时候，不需要取消、开始调度按钮
              this.state.dispatchType === "voice"
                ? ""
                : [
                    <Button
                      key="voice"
                      onClick={() => {
                        this.setState({ createTaskStatus: false });
                        this.state.map.remove([this.state.overlays]);
                      }}
                    >
                      取消调度
                    </Button>,
                    <Button
                      key="text"
                      type="primary"
                      onClick={() => {
                        if (this.state.dispatchType === "text") {
                          if (this.state.schedulingName.trim().length === 0) {
                            message.warning("请输入调度任务名称");
                          } else if (
                            this.state.schedulingContent.trim().length === 0
                          ) {
                            message.warning("请输入调度任务内容");
                          } else {
                            this.state.map.remove([this.state.overlays]);
                            //输入的数据都没有错的时候，开始文字调度（创建群组）
                            this.createGroup();
                          }
                        }
                        if (this.state.dispatchType === "voice") {
                          //语音调度
                        }
                        if (this.state.dispatchType === "video") {
                          if (this.state.schedulingName.trim().length === 0) {
                            message.warning("请输入调度任务名称");
                          } else if(this.state.recordMobile.length>16){
                            message.error("录制人数限制16个以内,请重新选择")
                          } else {
                            this.state.map.remove([this.state.overlays]);
                            this.state.map.clearInfoWindow();
                            //开始视频调度
                            this.video(
                              this.state.selectedPoints,
                              this.state.schedulingName.trim(),
                              this.state.recordMobile
                            ); //选中的人员，调度任务名称
                          }
                        }
                      }}
                    >
                      开始调度
                    </Button>,
                  ]
            }
          >
            <ModalView
              selectedPoints={this.state.selectedPoints}
              dispatchType={this.state.dispatchType}
              showRecord={this.state.showRecord}
              schedulingName={(value) => {
                this.setState({ schedulingName: value });
              }}
              schedulingContent={(value) => {
                this.setState({ schedulingContent: value });
              }}
              voiceGroup={(url, time) => {
                this.voiceGroup(url, time);
              }}
              showRecord={(value) => {
                this.setState({ showRecord: value });
              }}
              onCheckPerRecord={(recordMobile) => {
                console.log(recordMobile);
                this.setState({ recordMobile });
              }}
            />
          </Modal>
          {/* im可视化页面 */}
          <IM
            visible={this.state.imStatus}
            closeClick={() => {
              this.setState({ imStatus: !this.state.imStatus });
            }}
            conversationID={this.state.conversationID}
          ></IM>
          {/* IM视频页面 */}
          {this.state.videoStatus && (
            <Video
              Room_No={this.state.Room_No}
              mobilePhone={this.props.mobilePhone}
              imSig={this.props.imSig}
              closeVideoState={() => {
                this.setState({
                  videoStatus: !this.state.videoStatus,
                });
              }}
              schedulingName={this.state.schedulingName}
              isNeedRecord={this.state.isNeedRecord}
            ></Video>
          )}

          {/* 单人的语音调度调起的录音页面 */}
          {this.state.onlyPersonVoiceStatus && (
            <div className="only-person-voice">
              <div className="avatar-header">
                {this.state.selectedData.photoUrl ? (
                  <img src={this.state.selectedData.photoUrl}></img>
                ) : (
                  <span className="img-span">
                    {this.state.selectedData.name.substring(
                      this.state.selectedData.name.length - 2,
                      this.state.selectedData.name.length
                    )}
                  </span>
                )}
                <span className="label-voice">语音调度</span>
                <div
                  className="close"
                  onClick={() => {
                    this.setState({
                      onlyPersonVoiceStatus: false,
                    });
                  }}
                >
                  x
                </div>
              </div>
              <Record
                where="index"
                sendSound={(url, time) => {
                  //点击了发送
                  //关掉单人的录音页面
                  this.setState({
                    onlyPersonVoiceStatus: false,
                  });
                  //主要是区分了群组页面的语音调度内容
                  const conversonID = this.state.selectedData.mobilePhone
                    ? `C2C${this.state.selectedData.mobilePhone}`
                    : this.state.selectedData.conversonGroupID;
                  const type = this.state.selectedData.mobilePhone
                    ? TIM.TYPES.CONV_C2C
                    : TIM.TYPES.CONV_GROUP;
                  const id = this.state.selectedData.mobilePhone
                    ? this.state.selectedData.mobilePhone + ""
                    : this.state.selectedData.group;
                  tim.getConversationProfile(conversonID).then(({ data }) => {
                    // 3.1 更新当前会话
                    this.props.dispatch({
                      type: `im/updateCurrentConversation`,
                      payload: data.conversation,
                    });
                    this.setState({
                      conversationID: conversonID,
                      imStatus: true,
                      needCreateConversation: true,
                    });
                    //发送单人的语音
                    this.sendCustomMessage(id, url, time, type);
                    return Promise.resolve();
                  });
                }}
              />
            </div>
          )}
        </div>
      </Container>
    );
  }
}

const Container = style.div`
              width:100%;
              height:100%;
            `;
