/**
 *所有驻勤点
 */
import React, { Component } from "react";
import { connect } from "dva";
import { withRouter } from "dva/router";
import { Pagination, message, Icon, Input, Button, Select } from "antd";
import { data } from "./TypeData";
import {
  policeGetTaskList,
  policeGetComList,
} from "../../../../../services/api";
import AttendanceItem from "./AttendanceItem";
const Option = Select.Option;
@connect((state) => ({
  selectedId: state.command.attendanceList.selectedId,
  tabIndex2: state.command.tabIndex.attendance.tabIndex2,
}))
@withRouter
export default class AllAttendance extends Component {
  constructor(props) {
    super(props);
    this.state = {
      tabKey: "1", //tab
      currentKey: null, //主要用于处理tab页面改变，不让重新请求数据
      data: data,
      searchData: {
        //搜索数据
        pageNumber: 1,
        pageSize: 9,
        taskName: null,
        belongComId: "", //所属企业ID
      },
      selectedIndex: null, //选中哪个列表
      selectedAttenData: null, //选中的驻勤点的信息
      total: 0, //搜索总页数
      attendanceList: [], //搜索出的驻勤点的数据
      height: null, //搜索列表的最大高度
      belongComList: [
        {
          comName: "请输入企业名称",
          comId: "",
        },
      ], //搜索出的企业列表
      loadingText: "暂无数据",
    };
  }

  componentDidMount() {
    const height = document.documentElement.clientHeight - 120 - 130 - 40 - 110;
    this.setState({ height });
    this.getAttendanceList(1); //默认页面中是空搜索
    this.getPoliceGetComList();
  }
  componentWillReceiveProps(nextProps) {
    if (
      nextProps.tabIndex2 == this.state.tabKey &&
      nextProps.tabIndex2 !== this.state.currentKey
    ) {
      this.setState({
        currentKey: nextProps.tabIndex2,
      });
      this.getAttendanceList(this.state.searchData.pageNumber);
    }
    if (nextProps.tabIndex2 != this.state.tabKey) {
      this.setState({
        currentKey: null,
      });
    }
  }
  //获取搜索值
  getAttendanceList(pageNumber) {
    // this.props.attenPersonList([]);
    //先重置分页数据
    this.setState(
      {
        searchData: {
          ...this.state.searchData,
          pageNumber,
        },
        selectedIndex: null, //清空驻勤的点击哪个列表的信息
        selectedAttenData: null,
        loadingText: "正在加载中...",
      },
      () => {
        policeGetTaskList({
          ...this.state.searchData,
        }).then((res) => {
          if (res.retType === "0") {
            const data = this.state.data;
            const attendanceList = res.data.data;
            const attendanceLength = attendanceList.length
            const dataLength = data.length
            for (let i = 0; i < attendanceLength; i++) {
              for (let j = 0; j < dataLength; j++) {
                if (attendanceList[i].taskStationType == data[j].key) {
                  attendanceList[i].markerIcon = data[j].markerIcon;
                  attendanceList[i].clickMarkerIcon = data[j].clickMarkerIcon;
                }
                break;
              }
              if (!attendanceList[i].markerIcon) {
                attendanceList[i].markerIcon = data[dataLength - 1].markerIcon;
                attendanceList[i].clickMarkerIcon =
                  data[dataLength - 1].clickMarkerIcon;
              }
            }
            this.setState({
              attendanceList,
              total: res.data.total,
              loadingText: res.data.data.length > 0 ? "加载完成" : "暂无数据",
            });
            this.props.dispatch({
              type: "command/fetchAllAttendanceList",
              payload: {
                attendanceList,
              },
            });
          }
        });
      }
    );
  }
  //获取公安保安行业公司
  getPoliceGetComList(value) {
    policeGetComList({
      comName: value,
    }).then((res) => {
      if (res.retType === "0") {
        this.setState({
          belongComList: res.data,
        });
      }
    });
  }
  renderOptionList = () => {
    return this.state.belongComList.map((val, key) => {
      return (
        <Option key={key} value={val.comId}>
          {val.comName}
        </Option>
      );
    });
  };

  handleSearch(value) {
    this.getPoliceGetComList(value);
  }
  handleChange(value) {
    this.setState({
      searchData: {
        ...this.state.searchData,
        belongComId: value,
      },
    });
  }
  render() {
    return (
      <div className="data-list">
        <div className="input">
          <Input
            placeholder="请输入驻勤点:"
            value={this.state.searchData.taskName}
            style={{ width: 270, marginRight: "5px" }}
            onChange={(e) => {
              this.setState({
                searchData: {
                  ...this.state.searchData,
                  taskName: e.target.value.trim(),
                },
              });
            }}
            onPressEnter={() => {
              //按下回车获取列表值
              this.getAttendanceList(1);
            }}
          />
          <Select
            value={this.state.searchData.belongComId}
            defaultActiveFirstOption={false}
            // showArrow={false}
            filterOption={false}
            style={{ width: 270, marginTop: "5px" }}
            placeholder="请选择"
            showSearch
            onSearch={(value) => this.handleSearch(value)}
            onChange={(value) => this.handleChange(value)}
          >
            {this.renderOptionList()}
          </Select>
          <Button
            type="primary"
            onClick={() => {
              //获取搜索值
              this.getAttendanceList(1);
            }}
            style={{ marginTop: "5px", marginRight: "5px" }}
          >
            搜索
          </Button>
          <Button
            // type="primary"
            style={{ marginTop: "5px" }}
            onClick={() => {
              this.setState(
                {
                  searchData: {
                    pageNumber: 1,
                    pageSize: 7,
                    taskName: null,
                    belongComId: "", //所属企业ID
                  },
                  // belongComList: [
                  //   {
                  //     comName: "请输入企业名称",
                  //     comId: "",
                  //   },
                  // ], //搜索出的企业列表
                },
                () => {
                  this.getAttendanceList(1);
                }
              );
            }}
          >
            重置
          </Button>
        </div>
        <div className="security search-list_command amap_lib_placeSearch">
          <div
            className="list"
            style={{ maxHeight: this.state.height, overflow: "auto" }}
          >
            <AttendanceItem
              data={this.state.attendanceList}
              loadingText={this.state.loadingText}
            />
          </div>
          <Pagination
            total={this.state.total}
            size="small"
            onChange={(number) => {
              this.getAttendanceList(number);
            }}
            defaultPageSize={this.state.searchData.pageSize}
            current={this.state.searchData.pageNumber}
            style={{ display: this.state.total > 1 ? "block" : "none" }}
          />
        </div>
      </div>
    );
  }
}
