export default {
  namespace: 'im',
  state: {
    imSig: null,
    isSDKReady: null, // TIM SDK 是否 ready
    conversationList: [],
    currentUserProfile: {}, //当前选中的对话的用户
    currentConversation: {},
    currentMessageList: [],
    nextReqMessageID: '',
    isCompleted: false, // 当前会话消息列表是否已经拉完了所有消息
    totalUnreadCount:null,//当前会话未读数
    currentPlayVideo:[],//当前播放的音频
  },
  effects: {
    //获取腾讯im的sig
    *fetchSig({ payload }, { put }) {
      yield put({
        type: 'changeImSig',
        payload
      });
    },
    *conversationList({ payload }, { put }) {
      yield put({
        type: 'changeConversationList',
        payload
      });
    },
    *totalUnreadCount({ payload }, { put }) {
      yield put({
        type: 'changeTotalUnreadCount',
        payload
      });
    },
    /*获取sdk是否有准备好*/
    *toggleIsSDKReady(_, { put }) {
      yield put({
        type: 'changeSDKReadyStatus',
        payload: true
      });
    },
    /**获取消息列表数据 */
    *updateList(_, { put }) {
      yield put({
        type: 'updateConversationList',
        payload
      });
    },
    *updateCurrentUserProfile({ payload }, { put }) {
      yield put({
        type: 'changeCurrentUserProfile',
        payload
      });
    },
    //通过点击改变当前的会话
    *updateCurrentConversation({ payload }, { put }) {
      yield put({
        type: 'changeCurrentConversation',
        payload
      });
    },
    //通过点击改变当前的会话的内容
    *updateCurrentConversationCont({ payload }, { put }) {
      yield put({
        type: 'changeCurrentConversationCont',
        payload
      });
    },
    //发送消息，改变消息列表(改变currentMessageList)
    *pushCurrentMessageList({ payload }, { put }) {
      yield put({
        type: 'changeSendMessageList',
        payload
      });
    },
    // //存储当前播放的音频
    // *updateCurrentPlayVideo({ payload }, { put }) {
    //   console.log(payload)
    //   yield put({
    //     type: 'changeCurrentPlayVideo',
    //     payload
    //   });
    // },
  },

  reducers: {
    changeImSig(state, { payload }) {
      return {
        ...state,
        imSig: payload.sig
      };
    },
    changeConversationList(state, { payload }) {
      const totalUnreadCount= payload.reduce((count, conversation) => {
        // 当前会话不计算总未读
        if (conversation.conversationID === payload.conversationID) {
          return count
        }
        if (
          conversation.type === 'GROUP' &&
          conversation.groupProfile.selfInfo.messageRemindType === 'AcceptNotNotify'
        ) {
          return count
        }
        return count + conversation.unreadCount
      }, 0)
      return {
        ...state,
        conversationList: payload,
        totalUnreadCount
      };
    },
    changeTotalUnreadCount(state, { payload }) {
      const totalUnreadCount= state.conversationList.reduce((count, conversation) => {
        // 当前会话不计算总未读
        if (conversation.conversationID === state.conversationList.conversationID) {
          return count
        }
        if (
          conversation.type === 'GROUP' &&
          conversation.groupProfile.selfInfo.messageRemindType === 'AcceptNotNotify'
        ) {
          return count
        }
        return count + conversation.unreadCount
      }, 0)
      return {
        ...state,
        totalUnreadCount
      };
    },
    changeSDKReadyStatus(state, { payload }) {
      return {
        ...state,
        isSDKReady: payload
      };
    },
    updateConversationList(state, { payload }) {
      return {
        ...state,
        conversationList: payload
      };
    },
    changeCurrentUserProfile(state, { payload }) {
      return {
        ...state,
        currentUserProfile: payload
      };
    },
    changeCurrentConversation(state, { payload }) {
      return {
        ...state,
        currentConversation: payload,
        currentMessageList: [],
        nextReqMessageID: '',
        isCompleted: false // 当前会话消息列表是否已经拉完了所有消息
      };
    },
    changeCurrentConversationCont(state, { payload }) {
      return {
        ...state,
        currentMessageList: payload.currentMessageList,
        nextReqMessageID: payload.nextReqMessageID,
        isCompleted: payload.isCompleted // 当前会话消息列表是否已经拉完了所有消息
      };
    },
    changeSendMessageList(state, { payload }) {
      return {
        ...state,
        currentMessageList: payload,
      };
    },
    // changeCurrentPlayVideo(state, { payload }) {
    //   console.log(state)
    //   return {
    //     ...state,
    //     currentPlayVideo: [state]
    //   };
    // },
  }
  
};
