import { queryNotices,getTencentImSig } from '../services/api';
import tim from '../utils/imInitialize';
const refresh = {
  HomePage: 0,//首页
  Organization: 0,
  enterprise: 0,
  PersonnelRecruitment: 2,//人事
  temporary: 2,//临保任务
  attendancemanagement: 2,
  salarymanagement: 2,
  medical: 1,
  insurancemanagement: 6,//金融保险
  finance: 6,
  invoice: 6,
  salarypayment: 6,
  subsidyManage:12,
  xiaoxitongzhi: 3,//行政
  examinationapproval: 3,
  LaborCompensation: 2,
  devicesManagement: 3,
  training: 5,
  TrainingUnitsTrainingManagement: 5,
  TrainingInstitutionsCoursewareManagement: 5,
  TrainingInstitutionsTrainingManagement: 5,
  TrainingInstitutionsCertificationManage: 5,
  TrainingInstitutionsTrainingRecord:5,
  trainingAdapt: 5, //岗前适应性
  // TrainingInstitutionsExamManage: 5,
  Printing: 5,
  contractManagement: 3,
  taskmanager: 2,
  publicsafety: 7,
  datamap: 1,//数据地图
  PoliceDeclare: 4,//业务
  StatisticalSurvey:4,//业务
  data: 8,//数据统计
  meeting:9,//会议
  command:10,//防控指挥
  salary:13,//薪酬服务
  spotCheck:12,//资格证抽查
};
export default {
  namespace: 'global',
  state: {
    collapsed: true,
    menuInfo: [],
    notices: [],
    currentKey:'0',
    fetchingNotices: false,
    companyInfo:{
      "comId":"",
      "authType":"",
      "authStatus":"",
      "comName":"",
      "regProvince":'',
      "regCity":'',
      "regArea":'',
      "regAddress":"",
      "economicType":"",
      "industryType":"",
      "comType":"",
      "institutionType":"",
      "isBranchCom":"",
      "parentComName":"",
      "parentComRep":"",
      "parentComTel":"",
      "legalRepName":"",
      "nationality":"",
      "legalRepPhone":"",
      "idCardType":"",
      "idCardNo":"",
      "regAmount":'',
      "fixedAssets":'',
      "annualTurnover":'',
      "annualProfitTax":'',
      "comCerType":"",
      "comCerUrl":"",
      "comRegId":"",
    },
    imIsLogin:false,
    imSig:null,
    lMenu: true, //是否显示左侧菜单
    tMenu: true,  //是否显示顶部菜单
    footer: true,  //是否显示footer
    isShowSystemNotice:false,//是否显示过系统升级通知
  },

  effects: {
    *fetchNotices(_, { call, put }) {
      yield put({
        type: 'changeNoticeLoading',
        payload: false,
      });
      const data = yield call(queryNotices);
      yield put({
        type: 'saveNotices',
        payload: data.data,
      });
      yield put({
        type: 'user/changeNotifyCount',
        payload: data.length,
      });
    },
    *clearNotices({ payload }, { put, select }) {
      yield put({
        type: 'saveClearedNotices',
        payload,
      });
      const count = yield select(state => state.global.notices.length);
      yield put({
        type: 'user/changeNotifyCount',
        payload: count,
      });
    },
    *companyInfo({ payload }, { put}){
      yield put({
        type: 'getCompanyInfo',
        payload,
      });
    },
     /*获取腾讯IM，并完成IM登录*/
    *imLogin(action, { call,put }) {
      const data = yield call(getTencentImSig, action.payload.username);
      console.log(data.data)
      if(data.data){
        tim.login({
          userID:action.payload.username,
          userSig:data.data
        }).then(()=>{
          console.log("登录成功")
        })
        // if(data.data){
          yield put({
            type: "changeImLoginStatus",
            payload: data.data
          });
        // }
      }
    },
  },

  reducers: {
    getCompanyInfo(state, { payload }) {
      return {
        ...state,
        companyInfo: payload,
      };
    },
    changeLayoutCollapsed(state, { payload }) {
      return {
        ...state,
        collapsed: payload,
      };
    },
    saveMenuInfo(state, { payload }) {
      return {
        ...state,
        menuInfo: payload,
      };
    },
    saveNotices(state, { payload }) {
      return {
        ...state,
        notices: payload,
        fetchingNotices: false,
      };
    },
    saveClearedNotices(state, { payload }) {
      return {
        ...state,
        notices: state.notices.filter(item => item.type !== payload),
      };
    },
    changeNoticeLoading(state, { payload }) {
      return {
        ...state,
        fetchingNotices: payload,
      };
    },
    menuChange(state, { payload }){
      const currentGroup = refresh[window.location.pathname.split('/')[1]] || 0;
      return {
        ...state,
        currentKey: currentGroup,
      };
    },
    netError(state, { payload }) {
      return {
        ...state,
        netErr: true
      };
    },
    changeImLoginStatus(state, { payload }) {
      return {
        ...state,
        imIsLogin: true,
        imSig:payload
      };
    },
    changeLMenu(state, { payload }) {
      return {
        ...state,
        lMenu: payload.lMenu,
      };
    },
    changeTMenu(state, { payload }) {
      return {
        ...state,
        tMenu: payload.tMenu,
      };
    },
    changeFooter(state, { payload }) {
      return {
        ...state,
        footer: payload.footer,
      };
    },
    changeShowSystemNotice(state, { payload }) {
      return {
        ...state,
        isShowSystemNotice: payload,
      };
    },
  },
  
  subscriptions: {
    setup({ history, dispatch }) {
      
      // Subscribe history(url) change, trigger `load` action if pathname is `/`
      return history.listen(({ pathname, search }) => {
        if (typeof window.ga !== 'undefined') {
          window.ga('send', 'pageview', pathname + search);

          // 2020-1-10
          // 顶部菜单的选中
          const currentGroup = refresh[pathname.split('/')[1]] || 0;
          dispatch({
            type: 'menuChange',
            payload: currentGroup
          });

          if(pathname == '/salary/service') {
            // 隐藏左侧菜单
            // dispatch({
            //   type: 'changeLMenu',
            //   payload: {
            //     lMenu: false
            //   }
            // });
            //隐藏顶部菜单
            // dispatch({
            //   type: 'changeTMenu',
            //   payload: {
            //     lMenu: false
            //   }
            // });
          }else {
            dispatch({
              type: 'changeLMenu',
              payload: {
                lMenu: true
              }
            });
            dispatch({
              type: 'changeTMenu',
              payload: {
                tMenu: true
              }
            });
            dispatch({
              type: 'changeFooter',
              payload: {
                footer: true
              }
            });
          }
        }
      });
    },
  },
};
