import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export default app => {
  return {
    name: '考培负责人管理',
    icon: 'renshizhaopin',
    path: 'training',
    children: [
      {
        name: '考培负责人',
        path: 'person-in-charge',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/PersonInCharge/PersonInCharge')
        )
      },
    ]
  };
};
