/**
 * Created by Administrator on 2017/12/18 0018.驻勤值守
 */
import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const TaskManager = app => {
  let routers = {
    name: '驻勤管理',
    icon: 'renwuguanli',
    path: 'taskmanager',
    children: [
      {
        name: '驻勤值守',
        path: 'tasklist',
        component: dynamicWrapper(app, ['task'], () =>
          import('../routes/TaskManange/TaskList')
        )
      },
      {
        name: '驻勤人员查询',
        title: '驻勤人员查询',
        path: 'personSearch',
        component: dynamicWrapper(app, ['task'], () =>
          import('../routes/TaskManange/PersonSearch')
        )
      },
      {
        name: '驻勤班次管理',
        title: '驻勤班次管理',
        path: 'newshift2',
        component: dynamicWrapper(app, ['task'], () =>
          import('../routes/AttendanceManagement/NewShift')
        )
      },
      {
        name: '',
        title: '驻勤值守',
        path: 'tasklist/newtask',
        component: dynamicWrapper(app, ['task'], () =>
          import('../routes/TaskManange/NewTask')
        )
      },
      {
        name: '驻勤月报',
        title: '驻勤月报',
        path: 'monthstatistics',
        component: dynamicWrapper(app, ['task'], () =>
          import('../routes/TaskManange/Statistics/MonthStatistics')
        )
      },
      {
        name: '驻勤日报',
        title: '驻勤日报',
        path: 'daystatistics',
        component: dynamicWrapper(app, ['task'], () =>
          import('../routes/TaskManange/Statistics/DayStatistics')
        )
      },
      {
        name: '疫情防控',
        title: '疫情防控',
        path: 'epidemic',
        component: dynamicWrapper(app, ['task'], () =>
          import('../routes/TaskManange/Epidemic')
        )
      }
    ]
  };
  // routers.name = '外勤管理';
  // routers.children = routers.children.map(item => {
  //   const name = item.name && item.name.replace('驻勤', '外勤');
  //   const title = item.title && item.title.replace('驻勤', '外勤');
  //   return {
  //     ...item,
  //     name,title
  //   };
  // });
  return routers;
};
