import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const TrainingInstitutionsTrainingRecord = app => {
  return {
    name: '等级证学员实习记录',
    icon: 'renshizhaopin',
    path: 'TrainingInstitutionsTrainingRecord',
    children: [
      {
        name: '等级证学员实习审核记录',
        path: 'record',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsTrainingRecord/Record')
        )
      },
    ]
  };
};
