import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const TrainingInstitutionsTrainingManagement = app => {
  return {
    name: '培训管理',
    icon: 'renshizhaopin',
    path: 'TrainingInstitutionsTrainingManagement',
    children: [
      {
        name: '订单管理',
        path: 'OrderManagement',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsTrainingManagement/OrderManagement')
        )
      },
      {
        name: '退款管理',
        path: 'refund/manage',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsTrainingManagement/RefundManage')
        )
      },
      {
        name: '题库管理',
        path: 'QuestionBank',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsExamManage/QuestionBank')
        )
      },
      {
        name: '试卷管理',
        path: 'TestPaper',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsExamManage/TestPaper')
        )
      },
      
      {
        name: '班级管理',
        path: 'ClassManagement',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsTrainingManagement/ClassManagement')
        )
      },
      {
        name: '学习统计',
        path: 'LearningStatistics',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingInstitutionsTrainingManagement/LearningStatistics')
        )
      }
    ]
  };
};
