import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const StatisticalSurvey = app => {
  return {
    name: '统计调查',
    icon: 'renshizhaopin',
    path: 'StatisticalSurvey',
    children: [
      {
        name: '年度调查表',
        path: 'AnnualQuestionnaire',
        component: dynamicWrapper(app, [], () =>
          import('../routes/StatisticalSurvey/AnnualQuestionnaire')
        )
      },
      {
        name: '保安员离京登记',
        path: 'RegistrationFromBeijing',
        component: dynamicWrapper(app, [], () =>
          import('../routes/StatisticalSurvey/RegistrationFromBeijing')
        )
      }, {
        name: '临勤临保任务登记',
        path: 'TaskRegistration',
        component: dynamicWrapper(app, [], () =>
          import('../routes/StatisticalSurvey/TaskRegistration')
        )
      },
      {
        name: '保安协会等级评定',
        path: 'SecurityAssociationGrading',
        component: dynamicWrapper(app, [], () =>
          import('../routes/StatisticalSurvey/SecurityAssociationGrading')
        )
      }
    ]
  };
};
