import dynamic from "dva/dynamic";

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const Meeting = app => {
  return {
    name: "云会议",
    icon: "qiyeshouye saas saas-qiyeshouye",
    path: "meeting",
    children: [
      {
        name: "会议资源购买",
        path: "buy-setMeal",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting/BuySetMeal/index")
        )
      },
      {
        name: "会议资源管理",
        path: "resource",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting/Resource")
        )
      },
      {
        name: "会议用户管理",
        path: "user",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting/UserManage")
        ) 
      },
      {
        name: "云会议室管理",
        path: "clound-conference",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting/CloudConference/index")
        )
      },
      {
        name: "会议室",
        path: "meetingroom",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting")
        )
      },
      //菜单中的匿名加入会议
      // {
      //   name: "免费加入会议",
      //   path: "anonymous-join",
      //   component: dynamicWrapper(app, ["client"], () =>
      //     import("../routes/Meeting/AnonymousJoin/index")
      //   )
      // },
      // {
      //   name: "发起会议",
      //   path: "create",
      //   component: dynamicWrapper(app, ["client"], () =>
      //     import("../routes/Meeting/Create")
      //   )
      // },
      // {
      //   name: "加入会议",
      //   path: "join",
      //   component: dynamicWrapper(app, ["client"], () =>
      //     import("../routes/Meeting/Join/Join")
      //   )
      // },
      // {
      //   name: "预约会议",
      //   path: "appointment",
      //   component: dynamicWrapper(app, ["client"], () =>
      //     import("../routes/Meeting/Appointment")
      //   )
      // },
      {
        name: "会议控制",
        path: "control",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting/MyMeeting/Control")
        )
      },
      {
        name: "购买云会议资源",
        path: "buy-resouce",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting/BuySetMeal/BuyResource/index")
        )
      },
      {
        name: "购买云会议套餐",
        path: "buy-setMeal",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting/BuySetMeal/index")
        )
      },
      {
        name: "确认订单",
        path: "confirm-order",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting/BuySetMeal/BuyResource/ConfirmOrder")
        )
      },
      {
        name: "匿名加入",
        path: "anonymity-join",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting/MyMeeting/AnonymityJoin")
        )
      },
      {
        name: "录屏会议管理",
        path: "record",
        component: dynamicWrapper(app, ["client"], () =>
          import("../routes/Meeting/Record/index")
        )
      }
    ]
  };
};
