import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const ContractManagement = app => {
  return {
    name: '合同管理',
    icon: 'hetongguanli',
    path: 'contractManagement',
    children: [
      // {
      //   name: '合同列表',
      //   path: 'contractList',
      //   component: dynamicWrapper(app, ['profile'], () =>
      //     import('../routes/Administrative/ContractManagement/ContractList')
      //   )
      // },
      {
        name: '企业服务合同列表',
        path: 'enterpriseServiceContract',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/ContractManagement/EnterpriseServiceContract')
        )
      },
      {
        name: '劳务/劳动合同',
        path: 'laborContract',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/ContractManagement/Labor')
        )
      },
      {
        name: '', //添加合同
        title: '添加合同',
        path: 'addContract',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/ContractManagement/AddContract')
        )
      }
    ]
  };
};
