import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export default app => {
  return {
    name: '岗位适应性培训',
    icon: 'renshizhaopin',
    path: 'trainingAdapt',
    children: [
      {
        name: '岗位适应性培训学员管理',
        path: 'adapt-students',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/adaptTraining/StudentManagement')
        )
      }
    ]
  };
};
