/**
 * Created by Administrator on 2017/12/18 0018.人事招聘
 */
import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const PersonnelRecruitment = app => {
  return {
    name: '人事管理',
    icon: 'renshizhaopin',
    path: 'PersonnelRecruitment',
    children: [
      {
        name: '组织架构',
        path: 'departmentmanagement',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Organization/DepartmentManagement')
        )
      },
      {
        name: '', //组织架构-批量导入
        title: '组织架构', //组织架构-批量导入
        path: 'departmentmanagement/importexportNav',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Organization/ImportExportNav')
        )
      },
      {
        name: '离职记录', //组织架构-离职记录
        title: '组织架构', //组织架构-离职记录
        path: 'resignationlist',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Organization/ResignationList')
        )
      },
      {
        name: '', //人员信息
        title: '组织架构',
        path: 'departmentmanagement/PersonnelInformationNav',
        component: dynamicWrapper(app, ['profile', 'insurance'], () =>
          import('../routes/Enterprise/PersonnelInformation/PersonnelInformationNav')
        )
      },
      {
        name: '', //和修改同一个组件，分配不同路由
        title: '组织架构',
        path: 'departmentmanagement/addMember',
        component: dynamicWrapper(app, ['profile', 'insurance'], () =>
          import('../routes/Enterprise/PersonnelInformation/PersonnelInformationNav')
        )
      },
      {
        name: '人员查询',
        title: '人员查询',
        path: 'StaffQuery',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/PersonnelInformation/StaffQuery')
        )
      },
      {
        name: '保安人员导入',
        title: '保安人员导入',
        path: 'StaffQuery/import',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/PersonnelInformation/StaffQuery/staffQueryImport')
        )
      },
      {
        name: '角色权限',
        path: 'Role',
        component: dynamicWrapper(app, ['monitor'], () =>
          import('../routes/Enterprise/RoleAuthority/Role')
        )
      },
      {
        name: '奖惩管理',
        path: 'incentiveManagement',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Personnel/IncentiveManagement/ListContainer')
        )
      },
      {
        name: '问题人员',
        path: 'problemPersonnel',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Personnel/PersonnelManagement/ProblemPersonnel')
        )
      },
      {
        name: '人员招聘',
        path: 'ListContainer',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Personnel/PersonnelRecruitment/ListContainer')
        )
      },
      {
        name: '',
        title: '人员招聘',
        path: 'ListContainer/PositionDetail/:jobId/:type',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Personnel/PersonnelRecruitment/PositionDetail')
        )
      },
      {
        name: '',
        title: '人员招聘',
        path: 'ListContainer/ResumeDetails/:currentResumeId/:type',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Personnel/PersonnelRecruitment/ResumeDetails')
        )
      }
    ]
  };
};
