import dynamic from 'dva/dynamic';
import { EnterpriseHomePage } from './enterpriseHomePage';
// import { EnterpriseAddressBook } from "./enterpriseAddressBook";
import { EnterpriseManagement } from './enterpriseManagement';
import { PersonnelRecruitment } from './personnelRecruitment';
import { MessageNotification } from './messageNotification';
import { Administrative } from './administrative';
import { hrManagement } from './hrManagement';
import { TaskManager } from './taskManager';
import { PoliceDeclare } from './PoliceDeclare';
import { ExamInformation } from './ExamInformation';
import { StatisticalSurvey } from './StatisticalSurvey';
import { DevicesManagement } from './DevicesManagement';
import { ContractManagement } from './ContractManagement';
// import { IncentiveManagement } from "./IncentiveManagement";
import { AttendanceManagement } from './AttendanceManagement';
import { SalaryManagement } from './SalaryManagement';
import { ExaminationApproval } from './ExaminationApproval';
import { TrainingUnitsTrainingManagement } from './TrainingUnitsTrainingManagement';
import { PrintingCertificate } from './PrintingCertificate';
import { TrainingInstitutionsCoursewareManagement } from './TrainingInstitutionsCoursewareManagement';
import { TrainingInstitutionsTrainingManagement } from './TrainingInstitutionsTrainingManagement';
// import { TrainingInstitutionsExamManage } from './TrainingInstitutionsExamManage';
import { TrainingInstitutionsCertificationManage } from './TrainingInstitutionsCertificationManage';
import { TrainingInstitutionsTrainingRecord } from './TrainingInstitutionsTrainingRecord';
import trainingAdapt from './trainingAdapt';
import trainingPersonInCharge from './trainingPersonInCharge';
import { InsuranceManagement } from './InsuranceManagement';
import financialWallet from './financialWallet';
import SalaryPayment from './SalaryPayment';
import businessInvoice from './businessInvoice';
import QualifySubsidy from './QualifySubsidy';
import { HelpCenterFunctionIntroduction } from './HelpCenterFunctionIntroduction';
import { HelpCenterCommonProblems } from './HelpCenterCommonProblems';
import { HelpCenterOperationManual } from './HelpCenterOperationManual';
import { HelpCenterPersonnelImport } from './HelpCenterPersonnelImport';
import { HelpCenterDownloadClient } from './HelpCenterDownloadClient';
import { HelpCenterGiveUsAdvice } from './HelpCenterGiveUsAdvice';
import { DataMap } from './DataMap';
import { DataStatistics } from './dataStatistics';
import { Command } from './Command';
import { Meeting } from './Meeting';
import { PublicSafety } from './PublicSafety';
import temporaryInsurance from './temporaryInsurance';
import  salary from './salary';
// wrapper of dynamic

/**
 * iverry remark
 * 组件动态加载
 * @param {*} app  dva 实例，加载 models 时需要
 * @param {*} models  dva models(redux) 传入字符串，拼接model文件夹对应的名字 
 * @param {*} component 在返回 Promise 的函数，Promise 返回 React Component
 */
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

// nav data
export const getNavData = app => [
  {
    component: dynamicWrapper(app, ['user', 'login','client'], () =>
      import('../layouts/BasicLayout')
    ),
    layout: 'BasicLayout',
    name: '首页', // for breadcrumb
    path: '/',
    children: [
      /**
       * @author Orm
       * 企业模块-企业首页
       */
      EnterpriseHomePage(app),

      /**
       * @author Orm
       * 数据地图
       */
      DataMap(app),

      /**
       * @author Orm
       * 企业模块-企业通讯录
       */
      // EnterpriseAddressBook(app),

      /**
       * @author Lmb
       * 企业模块-企业管理
       */
      EnterpriseManagement(app),

      /**
       * @author Orm
       * 人事模块-人事招聘
       */
      PersonnelRecruitment(app),
      /**
       * @author Hjj
       * 人事模块-内勤管理
       * @author Lmb
       * 人事模块-五险一金设置
       *  @author cxl
       * 人事模块-奖惩管理
       */
      AttendanceManagement(app),
      /**
       * @author LYQ
       * 业务模块-驻勤管理-创建任务-任务详情
       */
      TaskManager(app),
      /**
       * @author Orm
       * 人事模块-薪酬管理
       */
      SalaryManagement(app),

      /**
       * @author  Lmb
       * 行政模块-消息
       */
      MessageNotification(app),
      /**
       * @author  Hjj
       * 行政模块-审批管理
       */
      ExaminationApproval(app),
      /**
       * @author  Xyz
       * 行政模块-劳务薪酬
       */
      Administrative(app),

      /**
       * @author cxl
       * 行政模块-设备管理
       */
      DevicesManagement(app),
      /**
       * @author cxl
       * 行政模块-合同管理
       */
      ContractManagement(app),

      /**
       * @author Lmb
       * 人事模块-五险一金设置
       */
      hrManagement(app),

      /**
       * @author cxl
       * 人事模块-奖惩管理
      IncentiveManagement(app),
      */
      
      /**
       * @author Hjj
       * 业务模块-备案许可申报
       */
      PoliceDeclare(app),
      /**
       * @author Hjj
       * 业务模块-保安员考培信息抽查管理
       */
      ExamInformation(app),
       /**
       * @author Hjj
       * 业务模块-统计调查
       */
      StatisticalSurvey(app),
      /**
       * @author Orm
       * 培训模块-参训单位-在线培训
       */
      TrainingUnitsTrainingManagement(app),
      
      /**
       * @author Orm
       * 培训模块-培训机构-课件库管理
       */
      TrainingInstitutionsCoursewareManagement(app),
      /**
       * @author Orm
       * 培训模块-培训机构-培训管理
       */
      TrainingInstitutionsTrainingManagement(app),
      /**
       * @author Orm
       * 培训模块-培训机构-考试管理
       */
      // TrainingInstitutionsExamManage(app),
      /**
       * @author Lyq
       * 培训模块-参训单位-在线培训
       */
      PrintingCertificate(app),
       /**
       * @author Lyq
       * 培训模块-培训机构-岗位适应性培训
       */
      trainingAdapt(app),
        /**
       * @author Cyq
       * 培训模块-培训机构-等级证管理
       */
      TrainingInstitutionsCertificationManage(app),
        /**
       * @author Lyq
       * 培训模块-培训机构-等级证管理
       */
      trainingPersonInCharge(app),
       /**
       * @author Lyq
       * 培训模块-培训机构-等级证学员实习审核记录
       */
      TrainingInstitutionsTrainingRecord(app),
      /**
       * @author Zjp
       * 金融保险模块-保险
       */
      InsuranceManagement(app),
      /**
       * @author Lyq
       * 金融保险模块-钱包
       */
      financialWallet(app),
      /**
       * @author Cyq
       * 金融保险模块-薪资发放管理
       */
      SalaryPayment(app),
      /**
       * @author Lyq
       * 业务发票模块-钱包
       */
      businessInvoice(app),
      /**
       * @author Cyq
       * 金融管理模块-资格证补贴发放管理
       */
      QualifySubsidy(app),
      /**
       * @author Zhx
       * SaaS帮助模块-功能简介
       */
      HelpCenterFunctionIntroduction(app),
      /**
       * @author Zhx
       * SaaS帮助模块-常见问题
       */
      HelpCenterCommonProblems(app),
      /**
       * @author Zhx
       * SaaS帮助模块-操作手册
       */
      HelpCenterOperationManual(app),
      /**
       * @author Zhx
       * SaaS帮助模块-人员导入指南
       */
      HelpCenterPersonnelImport(app),
      /**
       * @author Zhx
       * SaaS帮助模块-下载客户端
       */
      HelpCenterDownloadClient(app),
      /**
       * @author Zhx
       * SaaS帮助模块-给我们建议
       */

      HelpCenterGiveUsAdvice(app),
      /**
       * @author Orm
       * 大型活动
       */
      PublicSafety(app),
      /**
       * @author Lyq
       * 数据统计
       */
      DataStatistics(app),
      /**
       * @author Lyq
       * 防控指挥
       */
      Command(app),
      /**
       * @author Lyq
       * 薪酬
       */
      salary(app),
      /**
       * @author Lyq
       * 临保任务
       */
      temporaryInsurance(app),
      /**
       * 华为会议
       */
      Meeting(app),
      {
        name: '支付',
        path: 'pay',
        icon: 'warning',
        children: [
          {
            name: '支付',
            path: 'paystatus',
            component: dynamicWrapper(app, [], () =>
              import('../routes/pay/PayStatus')
            )
          }
        ]
      },
      {
        name: '异常',
        path: 'exception',
        icon: 'warning',
        children: [
          {
            name: '403',
            path: '403',
            component: dynamicWrapper(app, [], () =>
              import('../routes/Exception/403')
            )
          },
          {
            name: '404',
            path: '404',
            component: dynamicWrapper(app, [], () =>
              import('../routes/Exception/404')
            )
          },
          {
            name: '500',
            path: '500',
            component: dynamicWrapper(app, [], () =>
              import('../routes/Exception/500')
            )
          }
        ]
      }
    ]
  },
  {
    component: dynamicWrapper(app, ['user', 'register','im'], () =>
      import('../layouts/UserLayout')
    ),
    path: '/user',
    layout: 'UserLayout',
    children: [
      {
        name: '帐户',
        icon: 'user',
        path: 'user',
        children: [
          {
            name: '登录',
            path: 'LogOn',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/LogOn')
            )
          },
          {
            name: '注册',
            path: 'Enroll',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/Enroll')
            )
          },
          {
            name: '个人注册',
            path: 'PersonalRegistration',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/PersonalRegistration')
            )
          },
          {
            name: '个人注册成功',
            path: 'PersonalRegistrationResult',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/PersonalRegistrationResult')
            )
          },
          {
            name: '企业注册',
            path: 'EnterpriseRegistration',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/EnterpriseRegistration')
            )
          },
          {
            name: '企业注册成功',
            path: 'EnterpriseRegistrationResult',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/EnterpriseRegistrationResult')
            )
          },
          {
            name: '企业忘记密码',
            path: 'ForgetPassword',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/ForgetPassword')
            )
          },
          {
            name: '修改密码',
            path: 'ChangeUserPassword',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/ChangeUserPassword')
            )
          },
          {
            name: '用户协议',
            path: 'UserAgreement',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/UserAgreement')
            )
          },
          {
            name: '隐私策略',
            path: 'UserPlicy',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/UserPlicy')
            )
          },
          {
            name: '登录',
            path: 'Login',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/Login')
            )
          },
          {
            name: '登录',
            path: 'SignIn',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/SignIn')
            )
          },
        ]
      }
    ]
  },
  {
    component: dynamicWrapper(app, ['user', 'register'], () =>
      import('../layouts/PlatformLoginLayout')
    ),
    path: '/bbd',
    layout: 'PlatformLoginLayout',
    children: [
      {
        name: '百保盾',
        icon: 'user',
        path: 'bbd',
        children: [
          {
            name: '登录',
            path: 'login',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/PlatformLogin/BBDLogin')
            )
          },
          {
            name: '忘记密码',
            path: 'forgetpassword',
            component: dynamicWrapper(app, [], () =>
              import('../routes/User/PlatformLogin/ForgetPassword')
            )
          }
        ]
      }
    ]
  },
  {
    component: dynamicWrapper(app, [], () =>
      import('../layouts/fromV5Layout')
    ),
    path: '/fromv5',
    layout: 'FromV5Layout',
    children: [
      SalaryManagement(app),
      AttendanceManagement(app),
      TaskManager(app)
    ]
  }
];
