import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const EnterpriseManagement = app => {
  return {
    name: '企业管理',
    icon: 'qiyeguanli',
    path: 'enterprise',
    children: [
      {
        name: '企业信息',
        path: 'company',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Company/Company')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'company/insurance/:comInsId',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Company/InsuranceDetails')
        )
      },
      {
        name: '企业报备',
        path: 'reported',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/Reported')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/districtbasic',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/DistrictBasic')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/districtdetails/:crossManageId',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/DistrictDetails')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/overseasbasic',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/OverseasBasic')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/overseasdetails/:overseaManageId',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/OverseasDetails')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/shareholder',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/Shareholder')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/initializationstock',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/InitializationStock')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/changeownership',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/ChangeOwnership')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/shareholderchangelog',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/ShareholderChangeLog')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/managementbasic',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/ManagementBasic')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/managementadd/:comManagerId',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/ManagementAdd')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/managementchange',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/ManagementChange')
        )
      },
      {
        name: '',
        title: '企业管理',
        path: 'reported/managementchangereport',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/ManagementChangeReport')
        )
      },
      {
        name: '', //在职人员 离职人员
        title: '企业管理',
        path: 'jobtab',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Reported/JobTab')
        )
      },
      {
        name: '分公司管理',
        path: 'branchcompanymanager',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/BranchCompany/BranchCompanyManager')
        )
      },
      {
        name: '', //分公司管理层，分公司管理层变更记录
        title: '企业管理',
        path: 'branchcompanytab',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/BranchCompany/BranchCompanyTab')
        )
      },
      {
        name: '子公司管理', //子公司
        path: 'childcompanymanager',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/BranchCompany/ChildCompanyManager')
        )
      },
      {
        name: '企业设置',
        path: 'site',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Site/Set')
        )
      },
      {
        name: '监管设置', 
        path: 'regulator-set',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Enterprise/Regulator/index')
        )
      }
    ]
  };
};
