
import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const DataStatistics = app => {
  return {
    name: '数据统计',
    icon: 'qiyeshouye saas saas-qiyeshouye',
    path: 'data',
    children: [
      {
        name: '企业统计',
        path: 'com-statistics',
        component: dynamicWrapper(app, [], () =>
          import('../routes/DataStatistics/ComStatistics')
        )
      }
    ]
  };
};
