import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const Administrative = app => {
  return {
    name: '劳务薪酬',
    icon: 'laowuxinchou',
    path: 'adminis',
    children: [
      {
        name: '薪酬报表',
        path: 'labor',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/LaborCompensation/LaborBasic')
        )
      },
      {
        //新建报表
        name: '',
        title: '劳务薪酬',
        path: 'newlabor',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/LaborCompensation/LaborNew')
        )
      },
      {
        //查看报表
        name: '',
        title: '劳务薪酬',
        path: '/reportget/:reportId/:type',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/LaborCompensation/ReportGet')
        )
      },
      {
        //编辑报表
        name: '',
        title: '劳务薪酬',
        path: '/reportUpdate/:reportId/:type',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Administrative/LaborCompensation/ReportUpdate')
        )
      }
    ]
  };
};
