import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const TrainingUnitsTrainingManagement = app => {
  return {
    name: '在线培训',
    icon: 'renshizhaopin',
    path: 'TrainingUnitsTrainingManagement',
    children: [
      {
        name: '课程列表',
        path: 'CoursesList',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingUnitsTrainingManagement/CoursesList')
        )
      },
      {
        name: '订单管理',
        path: 'OrderManagement',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingUnitsTrainingManagement/OrderManagement')
        )
      },
      {
        name: '资格证学员管理',
        path: 'StudentManagement',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingUnitsTrainingManagement/StudentManagement')
        )
      },
      {
        name: '学习统计',
        path: 'LearningStatistics',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingUnitsTrainingManagement/LearningStatistics')
        )
      },
      {
        name: '退款记录',
        path: 'refund/record',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Training/TrainingUnitsTrainingManagement/RefundRecord')
        )
      },
    ]
  };
};
