/**
 * Created by Administrator on 2019/01/02 0018.薪酬管理
 */
import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const SalaryManagement = app => {
  return {
    name: '薪酬管理',
    icon: 'kaoqinguanli',
    path: 'salarymanagement',
    children: [
      {
        name: '薪酬模板',
        path: 'template',
        component: dynamicWrapper(app, [], () =>
          import('../routes/SalaryManagement/Template')
        )
      },
      {
        name: '',
        title: '薪酬模板',
        path: 'template/add/:comSalaryTempId/:type',
        component: dynamicWrapper(app, [], () =>
          import('../routes/SalaryManagement/Add')
        )
      },
      {
        name: '薪酬核算',
        path: 'accounting',
        component: dynamicWrapper(app, [], () =>
          import('../routes/SalaryManagement/Accounting')
        )
      },
      {
        name: '导入工资数据',
        path: 'importSalary',
        component: dynamicWrapper(app, [], () =>
          import('../routes/SalaryManagement/ImportSalary')
        )
      },
      // 五险一金设置模块从人事管理迁移到薪酬管理
      {
        name: '五险一金设置',
        path: 'medicalrecord',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Personnel/Medical/MedicalBasic')
        )
      },
      {
        name: '',
        title: '五险一金设置',
        path: 'proportion',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Personnel/Medical/PayBasic')
        )
      },
      {
        name: '',
        title: '五险一金设置',
        path: '/proporset/:schemeId',
        component: dynamicWrapper(app, ['profile'], () =>
          import('../routes/Personnel/Medical/PaySet')
        )
      }
    ]
  };
};
