import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export default app => {
  return {
    name: '补贴发放管理',
    icon: 'renshizhaopin',
    path: 'subsidyManage',
    children: [
      {
        name: '保安资格证考务补贴', //购买在线保险 保险商城
        path: 'affairs',
        component: dynamicWrapper(app, ['invoice'], () =>
          import('../routes/SubsidyManage/Affairs')
        )
      },
      {
        name: '职业技能培训补贴（五级）', //购买在线保险 保险商城
        path: 'training',
        component: dynamicWrapper(app, ['invoice'], () =>
          import('../routes/SubsidyManage/Training')
        )
      },
    ]
  };
};