import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const HelpCenterCommonProblems = app => {
  return {
    name: '常见问题',
    icon: 'renshizhaopin',
    path: 'HelpCenterCommonProblems',
    children: [
      {
        name: '常见问题',
        path: 'CommonProblems',
        component: dynamicWrapper(app, [], () =>
          import('../routes/HelpCenter/CommonProblems/CommonProblems')
        )
      }
    ]
  };
};
