import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export default app => {
  return {
    name: '金融钱包',
    icon: 'renshizhaopin',
    path: 'finance',
    children: [
      {
        name: '企业钱包', //购买在线保险 保险商城
        // title: '保险商城',
        path: 'business-wallet',
        component: dynamicWrapper(app, ['financial'], () =>
          import('../routes/financialWallet/BusinessWallet')
        )
      },
      {
        name: '钱包协议', //购买在线保险 保险商城
        // title: '保险商城',
        path: 'agreement/wallet',
        component: dynamicWrapper(app, ['financial'], () =>
          import('../routes/financialWallet/Agreement')
        )
      },
      {
        name: '员工钱包', //购买在线保险 保险商城
        // title: '保险商城',
        path: 'employee-wallet',
        component: dynamicWrapper(app, ['financial'], () =>
          import('../routes/financialWallet/EmployeeWallet')
        )
      },
      // {
      //   name: '', //购买在线保险 保险商城
      //   title: '薪资代发',
      //   path: 'salary-proxy-list',
      //   component: dynamicWrapper(app, ['financial'], () =>
      //     import('../routes/financialWallet/SalaryProxy/WaitingList')
      //   )
      // },
      // {
      //   name: '', //购买在线保险 保险商城
      //   title: '薪资代发',
      //   path: 'salary-proxy-fail',
      //   component: dynamicWrapper(app, ['financial'], () =>
      //     import('../routes/financialWallet/SalaryProxy/FailList')
      //   )
      // },
      // {
      //   name: '', //购买在线保险 保险商城
      //   title: '薪资代发',
      //   path: 'salary-proxy-complete',
      //   component: dynamicWrapper(app, ['financial'], () =>
      //     import('../routes/financialWallet/SalaryProxy/CompleteList')
      //   )
      // },
      // {
      //   name: '保安员证联名卡',
      //   title: '保安员证联名卡',
      //   path: 'smart-card',
      //   component: dynamicWrapper(app, ['financial'], () =>
      //     import('../routes/financialWallet/SmartCard')
      //   )
      // },
      // {
      //   name: '企业发薪账户', 
      //   path: 'salary-account',
      //   component: dynamicWrapper(app, ['financial'], () =>
      //     import('../routes/financialWallet/SalaryAccount')
      //   )
      // },
      // {
      //   name: '在线薪资代发申请', 
      //   path: 'salary-proxy-online',
      //   component: dynamicWrapper(app, ['financial'], () =>
      //     import('../routes/financialWallet/SalaryProxyOnline')
      //   )
      // },
      // {
      //   name: '代发详情', 
      //   path: 'salary-proxy-online/list',
      //   component: dynamicWrapper(app, ['financial'], () =>
      //     import('../routes/financialWallet/SalaryProxyOnline/List')
      //   )
      // },
      // {
      //   name: '线下薪资发放记录', //购买在线保险 保险商城
      //   title: '线下薪资发放记录',
      //   path: 'salary-proxy',
      //   component: dynamicWrapper(app, ['financial'], () =>
      //     import('../routes/financialWallet/SalaryProxy')
      //   )
      // },
      // {
      //   name: '线下薪资发放记录', 
      //   path: 'salary-proxy-offline',
      //   component: dynamicWrapper(app, ['financial'], () =>
      //     import('../routes/financialWallet/SalaryProxyOffline')
      //   )
      // },
    ]
  };
};