import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const ExamInformation = app => {
  return {
    name: '保安员考培信息抽查管理',
    icon: 'renshizhaopin',
    path: 'spotCheck',
    children: [
      {
        name: '保安员资格证考培信息抽查',
        path: 'certificateMessage',
        component: dynamicWrapper(app, [], () =>
          import('../routes/ExamInformation/CertificateMessage')
        )
      },
      {
        name: '保安员资格证考培信息抽查记录',
        path: 'certificateRecord',
        component: dynamicWrapper(app, [], () =>
          import('../routes/ExamInformation/CertificateRecord')
        )
      },
      {
        name: '资格证信息审查',
        path: 'certificateReview',
        component: dynamicWrapper(app, ['certificate'], () =>
          import('../routes/ExamInformation/CertificateReview')
        )
      },
      {
        name: '资格证审查详情',
        path: 'certificateReview/detail',
        component: dynamicWrapper(app, ['certificate'], () =>
          import('../routes/ExamInformation/CertificateReview/detail')
        )
      },
      {
        name: '保安员等级证考培信息抽查',
        path: 'gradeMessage',
        component: dynamicWrapper(app, [], () =>
          import('../routes/ExamInformation/GradeMessage')
        )
      },
      {
        name: '保安员等级证考培信息抽查记录',
        path: 'gradeRecord',
        component: dynamicWrapper(app, ['certificate'], () =>
          import('../routes/ExamInformation/GradeRecord')
        )
      },
      {
        name: '等级证信息审查',
        path: 'gradeReview',
        component: dynamicWrapper(app, ['certificate'], () =>
          import('../routes/ExamInformation/GradeReview')
        )
      },
      {
        name: '等级证审查详情',
        path: 'gradeReview/detail',
        component: dynamicWrapper(app, ['certificate'], () =>
          import('../routes/ExamInformation/GradeReview/detail')
        )
      },
    ]
  };
};
