import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const DataMap = app => {
  return {
    name: '数据地图',
    icon: 'renshizhaopin',
    path: 'datamap',
    children: [
      {
        name: '一键搜',
        path: 'onekeysearch',
        component: dynamicWrapper(app, [], () =>
          import('../routes/DataMap/OneKeySearch')
        )
      }
    ]
  };
};
