
import dynamic from 'dva/dynamic';

// wrapper of dynamic
const dynamicWrapper = (app, models, component) =>
  dynamic({
    app,
    models: () => models.map(m => import(`../models/${m}.js`)),
    component
  });

export const Command = app => {
  return {
    name: '防控指挥',
    icon: 'qiyeshouye saas saas-qiyeshouye',
    path: 'command',
    children: [
      {
        name: '防控指挥',
        path: 'prevention-and-control',
        component: dynamicWrapper(app, ['im','command'], () =>
          import('../routes/Command')
        )
      }, {
        name: '视频通话',
        path: 'video-call',
        component: dynamicWrapper(app, ['im'], () =>
          import('../routes/Command/Video')
        )
      }, {
        name: '录音',
        path: 'record',
        component: dynamicWrapper(app, [], () =>
          import('../routes/Command/Record')
        )
      }, {
        name: '临保的防控指挥',
        path: 'temporary',
        component: dynamicWrapper(app, ['im'], () =>
          import('../routes/CommandTemporary')
        )
      }
      // , {
      //   name: '调度记录',
      //   path: 'recordList',
      //   component: dynamicWrapper(app, ['im'], () =>
      //     import('../routes/Command/RecordList')
      //   )
      // }
      , {
        name: '融合调度指挥平台',
        path: 'fuse',
        component: dynamicWrapper(app, ['im','command'], () =>
          import('../routes/CommandFuse')
        )
      }
    ]
  };
};
