/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.seckill.SeckillActivityTime;
import com.zbkj.service.dao.SeckillActivityTimeDao;
import com.zbkj.service.service.SeckillActivityTimeService;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SeckillActivityTimeServiceImpl
extends ServiceImpl<SeckillActivityTimeDao, SeckillActivityTime>
implements SeckillActivityTimeService {
    @Resource
    private SeckillActivityTimeDao dao;

    @Override
    public List<SeckillActivityTime> findByActivityId(Integer activityId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SeckillActivityTime::getSeckillId, (Object)activityId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean deleteByActivityId(Integer activityId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.eq(SeckillActivityTime::getSeckillId, (Object)activityId);
        return this.remove((Wrapper)wrapper);
    }

    @Override
    public List<SeckillActivityTime> findByActivityStatus(Integer activityStatus, Integer dateInt, Integer timeInt) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (activityStatus.equals(1)) {
            lqw.nested(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.le(SeckillActivityTime::getStartDate, (Object)dateInt)).ge(SeckillActivityTime::getEndDate, (Object)dateInt);
            });
            lqw.nested(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)i.le(SeckillActivityTime::getStartTime, (Object)timeInt)).ge(SeckillActivityTime::getEndTime, (Object)timeInt);
            });
        }
        if (activityStatus.equals(2)) {
            lqw.lt(SeckillActivityTime::getEndDate, (Object)dateInt);
            lqw.or(o -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)o.eq(SeckillActivityTime::getEndDate, (Object)dateInt)).lt(SeckillActivityTime::getEndTime, (Object)timeInt);
            });
        }
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Integer getActivityStatus(Integer activityId, Integer dateInt, Integer timeInt) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SeckillActivityTime::getSeckillId, (Object)activityId);
        List timeList = this.dao.selectList((Wrapper)lqw);
        Integer activityStatus = 0;
        List timeList1 = timeList.stream().filter(e -> e.getStartDate() <= dateInt && dateInt <= e.getEndDate() && e.getStartTime() <= timeInt && e.getEndTime() >= timeInt).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(timeList1)) {
            activityStatus = 1;
            return activityStatus;
        }
        List timeList2 = timeList.stream().filter(e -> e.getEndDate() < dateInt || e.getEndDate().equals(dateInt) && e.getEndTime() < timeInt).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(timeList2)) {
            activityStatus = 2;
            return activityStatus;
        }
        return activityStatus;
    }

    @Override
    public List<Integer> findActivityByDateTime(Integer dateInt, Integer timeInt) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SeckillActivityTime::getId, SeckillActivityTime::getSeckillId});
        lqw.le(SeckillActivityTime::getStartDate, (Object)dateInt);
        lqw.ge(SeckillActivityTime::getEndDate, (Object)dateInt);
        lqw.le(SeckillActivityTime::getStartTime, (Object)timeInt);
        lqw.ge(SeckillActivityTime::getEndTime, (Object)timeInt);
        lqw.groupBy((Object[])new SFunction[]{SeckillActivityTime::getId, SeckillActivityTime::getSeckillId});
        List timeList = this.dao.selectList((Wrapper)lqw);
        return timeList.stream().map(SeckillActivityTime::getSeckillId).collect(Collectors.toList());
    }

    @Override
    public List<SeckillActivityTime> findFrontByDate(Integer dateInt) {
        return this.dao.findFrontByDate(dateInt);
    }

    @Override
    public List<Integer> findActivityByDateAndTime(Integer dateInt, Integer startTime, Integer endTime) {
        return this.dao.findActivityByDateAndTime(dateInt, startTime, endTime);
    }

    @Override
    public Boolean isInProgressNow(Integer activityId) {
        DateTime dateTime = DateUtil.date();
        String dateStr = dateTime.toString("yyyyMMdd");
        String hmStr = dateTime.toString("HHmm");
        return this.isInProgress(activityId, Integer.valueOf(dateStr), Integer.valueOf(hmStr));
    }

    @Override
    public Boolean isInProgress(Integer activityId, Integer dateInt, Integer timeInt) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SeckillActivityTime::getId});
        lqw.eq(SeckillActivityTime::getSeckillId, (Object)activityId);
        lqw.le(SeckillActivityTime::getStartDate, (Object)dateInt);
        lqw.ge(SeckillActivityTime::getEndDate, (Object)dateInt);
        lqw.le(SeckillActivityTime::getStartTime, (Object)timeInt);
        lqw.ge(SeckillActivityTime::getEndTime, (Object)timeInt);
        lqw.last(" limit 1");
        SeckillActivityTime seckillActivityTime = (SeckillActivityTime)this.dao.selectOne((Wrapper)lqw);
        return ObjectUtil.isNotNull((Object)seckillActivityTime);
    }

    @Override
    public Boolean isExistTimeInterval(Integer tid) {
        return this.dao.isExistTimeInterval(tid);
    }

    @Override
    public Boolean updateTimeByIntervalId(Integer tid, Integer startTime, Integer endTime) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillActivityTime::getStartTime, (Object)startTime);
        wrapper.set(SeckillActivityTime::getEndTime, (Object)endTime);
        wrapper.eq(SeckillActivityTime::getTimeIntervalId, (Object)tid);
        return this.update((Wrapper)wrapper);
    }
}

