package com.zbkj.common.response.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.HorizontalAlignmentEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import com.zbkj.common.enums.BcxPerformanceReportPayWayEnum;
import com.zbkj.common.enums.BcxSettleStatusEnum;
import com.zbkj.common.utils.DateConverter;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * description: 结算单-基础导出excel dto对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
public class BcxSettleBaseExcelDto implements Serializable {


    @ExcelProperty(value = "结算单号", order = 10)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String settleNo;

    @ExcelProperty(value = "账期", order = 11)
    @ColumnWidth(15)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String billPeriod;

    @ExcelProperty(value = "结算数量（条）", order = 12)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private Integer reportCount;

    @ExcelProperty(value = "实付总金额（元）", order = 13)
    @ColumnWidth(25)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private BigDecimal totalPrice;

    @ExcelProperty(value = "结算佣金（元）", order = 14)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private BigDecimal brokerageTotalPrice;

    @ExcelIgnore
    private Integer settleStatus;
    @ExcelProperty(value = "结算状态", order = 15)
    @ColumnWidth(15)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String settleStatusName;

    @ExcelProperty(value = "结算单生成时间", converter = DateConverter.class, order = 16)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private Date createTime;

    @ExcelProperty(value = "结算时间", converter = DateConverter.class, order = 17)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private Date settleTime;

    @ExcelIgnore
    private Integer payWay;
    @ExcelProperty(value = "支付方式", order = 18)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String payWayName;

    @ExcelIgnore
    private Integer uploadAttachments;
    @ExcelProperty(value = "发票/结算凭证", order = 19)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String uploadAttachmentsName;

    public String getSettleStatusName() {
        if (settleStatus != null) {
            return BcxSettleStatusEnum.getInstance(settleStatus).getName();
        }
        return null;
    }

    public String getPayWayName() {
        if (payWay != null) {
            return BcxPerformanceReportPayWayEnum.getInstance(payWay).getName();
        }
        return null;
    }

    public String getUploadAttachmentsName() {
        if (uploadAttachments != null) {
            return uploadAttachments == 1 ? "已上传" : "未上传";
        }
        return null;
    }
}