package com.zbkj.common.response.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.HorizontalAlignmentEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import lombok.Data;

/**
 * description: 业绩报表-分销用户导出excel dto对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
public class BcxPerformanceReportFxUserExcelDto extends BcxPerformanceReportBaseExcelDto {

    @ExcelIgnore
    private Integer brokerageUserType;
    @ExcelProperty(value = "分销员类型", order = 21)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String brokerageUserTypeName;

    @ExcelProperty(value = "分销员姓名", order = 22)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String brokerageUserRealName;

    @ExcelProperty(value = "分销员昵称", order = 23)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String brokerageUserNikeName;

    @ExcelProperty(value = "分销员手机号", order = 24)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String brokerageUserPhone;

    @ExcelProperty(value = "分销员所属企业", order = 25)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String brokerageUserOrg;

    public String getBrokerageUserTypeName() {
        if (brokerageUserType != null) {
            return brokerageUserType == 1 ? "企业" : "个人";
        }
        return null;
    }
}