package com.zbkj.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxProductInfoResponse对象", description = "PC端商品详情响应对象")
public class BcxProductInfoResponse implements Serializable {
    private static final long serialVersionUID = 1234532662346234545L;

    @ApiModelProperty(value = "商品id")
    private Integer id;

    @ApiModelProperty(value = "商品图片")
    private String image;

    @ApiModelProperty(value = "轮播图")
    private String sliderImage;

    @ApiModelProperty(value = "商品名称")
    private String name;

    @ApiModelProperty(value = "商品简介")
    private String intro;

    @ApiModelProperty(value = "关键字")
    private String keyword;

    @ApiModelProperty(value = "第一级分类id")
    private String firstLevelCategoryId;

    @ApiModelProperty(value = "第一级分类名称")
    private String firstLevelCategoryName;

    @ApiModelProperty(value = "第一级分类排序")
    private String firstLevelCategorySort;

    @ApiModelProperty(value = "第二级分类id")
    private String secondLevelCategoryId;

    @ApiModelProperty(value = "第二级分类名称")
    private String secondLevelCategoryName;

    @ApiModelProperty(value = "第二级分类排序")
    private String secondLevelCategorySort;

    @ApiModelProperty(value = "第三级分类id")
    private String thirdLevelCategoryId;

    @ApiModelProperty(value = "第三级分类名称")
    private String thirdLevelCategoryName;

    @ApiModelProperty(value = "第三级分类排序")
    private String thirdLevelCategorySort;

    @ApiModelProperty(value = "商户名称")
    private String merName;

    @ApiModelProperty(value = "商户分类ID")
    private Integer merCategoryId;

    @ApiModelProperty(value = "商户类型ID")
    private Integer merTypeId;

    @ApiModelProperty(value = "商户头像")
    private String merAvatar;

    @ApiModelProperty(value = "商品类型：0-实体, 1-虚拟, 2-特殊(考培), 3-保险, 4-风评")
    private Integer bizType;

    @ApiModelProperty(value = "主商品id，该字段有值的商品下单时需要关联主商品订单")
    private Integer masterId;

    @ApiModelProperty(value = "显示立即购买按钮 0-不显示 1-显示")
    private Boolean showBuyBtn;

    @ApiModelProperty(value = "显示申请试用按钮 0-不显示 1-显示")
    private Boolean showTryBtn;
}
