package com.zbkj.common.request.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 订单线下支付请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxPayOfflineRequest对象", description = "订单线下支付请求对象")
public class BcxPayOfflineRequest implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "订单号，用户确认支付时必传")
    private String orderNo;

    @ApiModelProperty(value = "用户支付说明")
    private String userMsg;

    @ApiModelProperty(value = "收款户名")
    private String bankUserName;

    @ApiModelProperty(value = "收款银行")
    private String bankName;

    @ApiModelProperty(value = "银行卡号")
    private String bankCard;
}
