package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * description: 业绩账单凭证表
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_settle_attachments")
@ApiModel(value = "BcxSettleAttachments对象", description = "业绩账单凭证表")
public class BcxSettleAttachments implements Serializable {
    
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id")
    private Long id;
    
    @ApiModelProperty(value = "结算id")
    private Long settleId;

    @ApiModelProperty(value = "附件类型，1发票，2结算凭证")
    private Integer type;
    
    @ApiModelProperty(value = "附件地址")
    private String url;

    @ApiModelProperty(value = "文件名")
    private String fileName;

    @ApiModelProperty(value = "扩展名")
    private String extName;
    
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    

}