package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 线下支付凭证
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_pay_offline_file")
@ApiModel(value = "BcxPayOfflineFile对象", description = "线下支付凭证")
public class BcxPayOfflineFile implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "线下支付凭证id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "线下支付id")
    private Integer payOfflineId;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "支付凭证名称")
    private String fileName;

    @ApiModelProperty(value = "支付凭证url")
    private String fileUrl;
}
