package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 发票源单据
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_fapiao_source")
@ApiModel(value = "BcxFapiaoSource对象", description = "发票源单据")
public class BcxFapiaoSource implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "源单id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "源单号：可重复，类型不一样")
    private String sourceNo;

    @ApiModelProperty(value = "0-商品购买 1-平台服务费2-渠道服务费 3-分销服务费")
    private Integer sourceType;

    @ApiModelProperty(value = "开票方id")
    private Integer writerId;

    @ApiModelProperty(value = "开票方")
    private String writer;

    @ApiModelProperty(value = "收票方id")
    private Integer receiverId;

    @ApiModelProperty(value = "收票方")
    private String receiver;

    @ApiModelProperty(value = "商品名称")
    private String productInfo;

    @ApiModelProperty(value = "商品三级分类id")
    private Integer categoryId;

    @ApiModelProperty(value = "生成时间")
    private Date sourceTime;

    @ApiModelProperty(value = "数量")
    private Integer quantity;

    @ApiModelProperty(value = "单价")
    private BigDecimal price;

    @ApiModelProperty(value = "金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "关联申请单，新增时为空")
    private String applyNo;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
