package com.zbkj.common.enums;

/**
 * description：账单结算状态：1待结算，2已结算
 * author：linchunpeng
 * date：2023/8/4
 */
public enum BcxSettleStatusEnum {

    WAIT_SETTLED("待结算", 1),
    SETTLED("已结算", 2);

    private final String name;
    private final Integer value;

    BcxSettleStatusEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }

    public static BcxSettleStatusEnum getInstance(int value) {
        switch (value) {
            case 1:
                return WAIT_SETTLED;
            case 2:
                return SETTLED;
        }
        return null;
    }
}
