package com.zbkj.common.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.ConfigurableApplicationContext;

import java.util.Arrays;

@Slf4j
public class GitConfig {

    public static void printGitInfo(ConfigurableApplicationContext context) {
        try {
            if (log.isInfoEnabled()) {
                GitProperties gitProperties = context.getBean(GitProperties.class);
                log.info("========== BCX.MALL Git版本 ==========");
                log.info("===== git origin url: {}", gitProperties.get("remote.origin.url"));
                log.info("===== git branch: {}", gitProperties.get("branch"));
                log.info("===== git commit id: {}", gitProperties.get("commit.id.full"));
                log.info("===== git commit user: {}", gitProperties.get("commit.user.name") + "<" + gitProperties.get("commit.user.email") + ">");
                log.info("===== git commit time: {}", gitProperties.get("commit.time"));
                log.info("===== git commit message: {}", gitProperties.get("commit.message.full"));
                String dirty = gitProperties.get("dirty");
                if ("true".equalsIgnoreCase(dirty)) {
                    log.warn("===== git dirty: {}", dirty);
                } else {
                    log.info("===== git dirty: {}", dirty);
                }
                log.info("===== git build time: {}", gitProperties.get("build.time"));
                log.info("===== git build host: {}", gitProperties.get("build.host"));
                String[] activeProfiles = context.getEnvironment().getActiveProfiles();
                if (activeProfiles.length > 0) {
                    log.info("===== active profiles: {}", Arrays.toString(activeProfiles));
                } else {
                    log.info("===== no active profiles ");
                }
                log.info("========== BCX.MALL 启动完成 ==========");
            }
        } catch (NoSuchBeanDefinitionException e) {
            log.warn(e.getMessage());
        }
    }
}
