/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.result;

import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.vo.MyRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommonResult<T>
implements Serializable {
    private static final long serialVersionUID = -6630747483482976634L;
    private Integer code;
    private String message;
    private T data;

    private CommonResult() {
        this.code = 200;
    }

    private CommonResult(T data) {
        this.code = 200;
        this.data = data;
    }

    private CommonResult(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    private CommonResult(Integer code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    private CommonResult(IResultEnum iResultEnum) {
        this.code = iResultEnum.getCode();
        this.message = iResultEnum.getMessage();
    }

    public static <T> CommonResult<T> success() {
        return new CommonResult<T>();
    }

    public static <T> CommonResult<T> success(T data) {
        return new CommonResult<T>(data);
    }

    public static CommonResult<Map<String, Object>> success(MyRecord record) {
        return new CommonResult<Map<String, Object>>(record.getColumns());
    }

    public static CommonResult<List<Map<String, Object>>> success(List<MyRecord> recordList) {
        ArrayList list = new ArrayList();
        recordList.forEach(i -> list.add(i.getColumns()));
        return new CommonResult<List<Map<String, Object>>>(list);
    }

    public static <T> CommonResult<T> failed(IResultEnum iResultEnum) {
        return new CommonResult<T>(iResultEnum);
    }

    public static <T> CommonResult<T> failed(CommonResultCode resultCode, String message) {
        return new CommonResult<T>(resultCode.getCode(), message);
    }

    public static <T> CommonResult<T> failed(CrmebException e) {
        return new CommonResult<T>(e.getCode(), e.getMessage());
    }

    public static <T> CommonResult<T> failed() {
        return CommonResult.failed(CommonResultCode.ERROR);
    }

    public static <T> CommonResult<T> failed(String message) {
        return new CommonResult<T>(CommonResultCode.ERROR.getCode(), message);
    }

    public long getCode() {
        return this.code.intValue();
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

