package com.zbkj.service.wangshang.notify.service.impl;

import com.zbkj.common.constants.Constants;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.ProtocolWithholdRefundResultNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.ProtocolWithholdRefundResultNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 协议代扣退款结果通知
 * ant.mybank.bkcloudfunds.protocol.withhold.refund.result.notify
 **/
@Service(value = "ProtocolWithholdRefundResultNotify")
public class ProtocolWithholdRefundResultNotifyServiceImpl implements MybankNotifyService {

    private static final Logger logger = LoggerFactory.getLogger(ProtocolWithholdRefundResultNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > 协议代扣退款结果通知：ant.mybank.bkcloudfunds.protocol.withhold.refund.result.notify");
        logger.info("========= > 请求报文："+context);
        //通知内容转换
        ProtocolWithholdRefundResultNotifyRequest notifyRequest =
                XmlConverter.getInstance().toResponse(context, ProtocolWithholdRefundResultNotifyRequest.class);
        RequestHead head = notifyRequest.getRefundResultNotify().getRequestHead();
        boolean flag = false;
        try {
            //通知内容保存
            flag = saveNotify(notifyRequest.getRefundResultNotify().getModel());
        }catch (Exception e){
            logger.error("========= > 协议授权代扣通知结果：ant.mybank.bkcloudfunds.protocol.withhold.result.notify:"+e.getMessage());
        }
        //响应结果根据执行结果统一处理
        String response = commomRequstHandle.getSignResult(flag, head);
        transactionLogService.save("协议代扣退款结果通知：ant.mybank.bkcloudfunds.protocol.withhold.refund.result.notify", Constants.Y, context,response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(ProtocolWithholdRefundResultNotifyModel model) {
        //TODO
        model.getRefundOrderNo();
        model.getRefundAmount();// 退款金额
        model.getRefundFinishDate();// 退款完成时间
        model.getRelateOrderNo();// 关联订单号
        model.getChannelRefundOrderNo();// 渠道退款订单号
        model.getStatus();// 状态(SUCCESS, FAIL,DEALING)
        model.getParticipantActualRefundAmount();// 实际退款金额
        model.getOutRefundNo();// 外部退款单号
        model.getRelateTransNo();// 关联交易流水号
        model.getErrorDesc();// 错误描述
        return true;
    }
}
