package com.zbkj.service.wangshang.api.service.base.bkcloudfunds;

import com.zbkj.service.wangshang.api.MybankApiException;
import com.zbkj.service.wangshang.api.MybankApiExceptionEnum;
import com.zbkj.service.wangshang.api.MybankConstants;
import com.zbkj.service.wangshang.api.MybankUploadRequest;
import com.zbkj.service.wangshang.api.domain.model.bkcloudfunds.BkcloudfundsOssFileUploadRequestModel;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;

/**
 * Mybank Api: ant.mybank.bkcloudfunds.oss.file.upload
 */
public class BkcloudfundsOssFileUploadRequest implements MybankUploadRequest<BkcloudfundsOssFileUploadResponse> {

    /**
     * API接口代码
     */
    private final String apiFunction = "ant.mybank.bkcloudfunds.oss.file.upload";

    /**
     * API接口版本
     */
    private String apiVersion = "1.0.0";

    /**
     * 文件
     */
    private static final String  FILE = "File";

    /**
     * 备注
     */
    private static final String  EXTINFO = "ExtInfo";

    /**
     * 序列号id
     */
    private static final String  SERIALVERSIONUID = "SerialVersionUID";

    /**
     * 文件上传请求参数
     */
    private BkcloudfundsOssFileUploadRequestModel requestModel;

    public BkcloudfundsOssFileUploadRequestModel getRequestModel() {return requestModel;}

    public void setRequestModel(BkcloudfundsOssFileUploadRequestModel requestModel) {
        if(requestModel.getFunction() == null){ requestModel.setFunction(this.apiFunction);}
        if(requestModel.getVersion() == null){ requestModel.setVersion(this.apiVersion);}
        this.requestModel = requestModel;
    }

    @Override
    public String getApiFunction() { return this.apiFunction; }

    @Override
    public String getApiVersion() { return this.apiVersion; }
    @Override
    public void setApiVersion(String apiVersion) { this.apiVersion = apiVersion; }

    @Override
    public Class<BkcloudfundsOssFileUploadResponse> getResponseClass() { return BkcloudfundsOssFileUploadResponse.class; }

    @Override
    public String uploadRequestSignString(Map<String, Object> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if(!FILE.equals(entryKey) && !EXTINFO.equals(entryKey)
                    && !MybankConstants.SIGNATURE.equals(entryKey) && entryValue instanceof String){
                stringBuffer.append(MybankConstants.AND_SYMBOL);
                stringBuffer.append(entryKey);
                stringBuffer.append(MybankConstants.EQUAL_SYMBOL);
                stringBuffer.append((String)entryValue);
            }
        }
        return URLEncoder.encode(stringBuffer.toString().substring(1));
    }

    @Override
    public Map<String, Object> getMapByModel() throws MybankApiException {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        if (this.requestModel == null){
            return map;
        }
        Class clazz = this.requestModel.getClass();
        Field[] fields = clazz.getDeclaredFields();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                String fieldName = field.getName();
                String s = fieldName.substring(0, 1).toUpperCase();
                String s1 = fieldName.substring(1);
                map.put(new StringBuffer(s).append(s1).toString(), field.get(this.requestModel));
            }
        } catch (Exception e) {
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION,e);
        }
        map.remove(SERIALVERSIONUID);
        return map;
    }

    @Override
    public HttpEntity entityBuilder(Map<String, Object> map) throws MybankApiException {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String entryKey = entry.getKey();
                Object entryValue = entry.getValue();
                if (entryValue instanceof String) {
                    String string = (String) entryValue;
                    entityBuilder.addPart(entryKey, new StringBody(string));
                } else if (entryValue instanceof File) {
                    File file = (File) entryValue;
                    entityBuilder.addBinaryBody(entryKey, file, ContentType.DEFAULT_BINARY, file.getName());
                } else {
                    throw new MybankApiException(MybankApiExceptionEnum.BUILD_HTTP_ENTITY_EXCEPTION);
                }
            }
        }catch (UnsupportedEncodingException e){
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION,e);
        }
        return entityBuilder.build();
    }
}
