package com.zbkj.service.wangshang.api.domain.model.bkcloudfunds;

import com.zbkj.service.wangshang.api.MybankObject;

import java.io.File;

/**
 * 云资金文件上传接口<ant.mybank.bkcloudfunds.oss.file.upload>
 * <p>
 */
public class BkcloudfundsOssFileUploadRequestModel extends MybankObject {
    private static final long serialVersionUID = -5168500500843179114L;

    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    private String isvOrgId;

    /**
     * 外部服务机构应用id
     * <p>
     * 由浙江网商银行统一分配,用于识别合作伙伴应用系统，即对端系统编号。
     * 注意此字段的大小写要求
     */
    private String appId;

    /**
     * 接口名称
     */
    private String function;

    /**
     * 接口版本
     */
    private String version;

    /**
     * 业务类型
     */
    private String bizType;

    /**
     * 文件类型
     */
    private String fileType;

    /**
     * 网商商户号
     */
    private String merchantId;

    /**
     * 外部交易号
     * <p>
     * 合作方系统生成的外部交易号，同一交易号被视为同一笔交易。
     */
    private String outTradeNo;

    /**
     * 报文发起时间
     * <p>
     * 格式：yyyyMMddHHmmss，请求发起时间
     */
    private String reqTime;

    /**
     * 签名值
     * <p>
     * 对部分字段做签名，签名字段包括：AppId,BizType,FileType,Function,IsvOrgId,MerchantId,OutTradeNo,ReqTime,Version
     * 签名算法：SHA256withRSA
     * 签名字段值以key=value形式根据字段组成字母进行字典升序排列，排列后的key=value键值对以“&”字符连接，最后对连接字符串进行URLEncode，获取待签名串
     */
    private String signature;

    /**
     * 上传文件
     * <p>
     * 上传的文件的内容（在发送请求时，文件内容以二进制数据流的形式发送）
     * 注意文件大小限定 20M 以内
     */
    private File file;

    /**
     * 扩展字段
     */
    private String extInfo;

    public String getIsvOrgId() {return isvOrgId;}
    public void setIsvOrgId(String isvOrgId) {this.isvOrgId = isvOrgId;}

    public String getAppId() {return appId;}
    public void setAppId(String appId) {this.appId = appId;}

    public String getFunction() {return function;}
    public void setFunction(String function) {this.function = function;}

    public String getVersion() {return version;}
    public void setVersion(String version) {this.version = version;}

    public String getBizType() {return bizType;}
    public void setBizType(String bizType) {this.bizType = bizType;}

    public String getFileType() {return fileType;}
    public void setFileType(String fileType) {this.fileType = fileType;}

    public String getMerchantId() {return merchantId;}
    public void setMerchantId(String merchantId) {this.merchantId = merchantId;}

    public String getOutTradeNo() {return outTradeNo;}
    public void setOutTradeNo(String outTradeNo) {this.outTradeNo = outTradeNo;}

    public String getReqTime() {return reqTime;}
    public void setReqTime(String reqTime) {this.reqTime = reqTime;}

    public String getSignature() {return signature;}
    public void setSignature(String signature) {this.signature = signature;}

    public File getFile() {return file;}
    public void setFile(File file) {this.file = file;}

    public String getExtInfo() {return extInfo;}
    public void setExtInfo(String extInfo) {this.extInfo = extInfo;}
}
