package com.zbkj.service.wangshang.api.domain.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <b> 商户详情 </b>
 * @author ZXF
 * @create 2025/06/09 0009 13:32
 * @version
 * @注意事项 </b>
 */
@Data
public class VostroInfo implements Serializable {
    @ApiModelProperty(value = "来账单号")
    @JSONField(name = "OrderNo")
    private String orderNo;
    @ApiModelProperty(value = "付方卡号")
    @JSONField(name = "PayerCardNo")
    private String payerCardNo;
    @ApiModelProperty(value = "付方户名")
    @JSONField(name = "PayerCardName")
    private String payerCardName;
    @ApiModelProperty(value = "充值金额")
    @JSONField(name = "TotalAmount")
    private String totalAmount;
    @ApiModelProperty(value = "可退回金额")
    @JSONField(name = "MaxRefundAmount")
    private String maxRefundAmount;
    @ApiModelProperty(value = "充值时间yyyyMMddHHmmss")
    @JSONField(name = "ChargeTime")
    private String chargeTime;
    @ApiModelProperty(value = "收方卡号")
    @JSONField(name = "PayeeCardNo")
    private String payeeCardNo;

    public void changeAmount(String TRADE_DEPOSIT){
        if(StringUtil.isNotEmpty(this.totalAmount)){
            this.totalAmount = String.valueOf(Double.parseDouble(this.totalAmount)/100);
        }
        if(StringUtil.isNotEmpty(this.maxRefundAmount)){
            this.maxRefundAmount = String.valueOf(Double.parseDouble(this.maxRefundAmount)/100);
            if(StringUtil.isNotEmpty(TRADE_DEPOSIT) && (new BigDecimal(TRADE_DEPOSIT)).compareTo(new BigDecimal(this.maxRefundAmount)) < 0){
                this.maxRefundAmount = TRADE_DEPOSIT;
            }
        }
    }
}
