package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;

/**
 * 商户入驻结果查询<ant.mybank.merchantprod.merch.register.query>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class MerchantprodMerchRegisterQueryResponseModel extends MybankObject {

    private static final long serialVersionUID = 9196281099822168539L;
    /**
     * 返回码组件
     * <p>
     * Result Status 返回S不代表入驻成功，只代表申请单据已经查询到，结果需要看RegisterStatus字段。
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 外部商户号
     */
    @XmlElement(name = "OutMerchantId")
    private String outMerchantId;

    /**
     * 申请单号
     */
    @XmlElement(name = "OrderNo")
    private String orderNo;

    /**
     * 商户号
     * <p>
     * 网商为商户分配的商户号，通过商户入驻结果查询接口获取。
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 入驻结果。可选值： 0：审核中; 1：成功; 2：失败
     * <p>
     * 当入驻结果为审核中，请间隔时间回查
     */
    @XmlElement(name = "RegisterStatus")
    private String registerStatus;

    /**
     * 外部交易号
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;


    /**
     * 入驻失败原因返回
     * <p>
     * 当商户入驻结果为失败时返回。可能出现的失败原因描述见附录
     */
    @XmlElement(name = "FailReason")
    private String failReason;

    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getOutMerchantId() {
        return outMerchantId;
    }

    public void setOutMerchantId(String outMerchantId) {
        this.outMerchantId = outMerchantId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getRegisterStatus() {
        return registerStatus;
    }

    public void setRegisterStatus(String registerStatus) {
        this.registerStatus = registerStatus;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getFailReason() {
        return failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }
}