package com.zbkj.service.wangshang.api.domain.model;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <b> 商户详情 </b>
 * @author ZXF
 * @create 2025/06/09 0009 13:32
 * @version
 * @注意事项 </b>
 */
@Data
public class MerchantDetail implements Serializable {
    @ApiModelProperty(value = "联系人手机号")
    @JSONField(name = "ContactMobile")
    private String contactMobile;
    @ApiModelProperty(value = "联系人姓名")
    @JSONField(name = "ContactName")
    private String contactName;
    @ApiModelProperty(value = "负责人手机号，企业非必传")
    @JSONField(name = "PrincipalMobile")
    private String principalMobile;
    @ApiModelProperty(value = "负责人证件类型")
    @JSONField(name = "PrincipalCertType")
    private String principalCertType = "01";
    @ApiModelProperty(value = "负责人证件号码,企业送法人代表证件号码")
    @JSONField(name = "PrincipalCertNo")
    private String principalCertNo;
    @ApiModelProperty(value = "负责人名称或企业法人代表姓名")
    @JSONField(name = "PrincipalPerson")
    private String principalPerson;
    @ApiModelProperty(value = "负责人证件有效期 如果负责人证件图片上传，则该字段必传")
    @JSONField(name = "PrincipalCertVld")
    private String principalCertVld;
    @ApiModelProperty(value = "经办人姓名：用于企业户后续激活；企业可选填")
    @JSONField(name = "HandlePerson")
    private String handlePerson;
    @ApiModelProperty(value = "经办人手机号，企业可选填")
    @JSONField(name = "HandlePersonMobile")
    private String handlePersonMobile;
    @ApiModelProperty(value = "经办人身份证号，企业可选填")
    @JSONField(name = "HandlePersonCertNo")
    private String handlePersonCertNo;
    @ApiModelProperty(value = "经办人证件号，企业可选填")
    @JSONField(name = "HandlerPersonCertType")
    private String handlerPersonCertType;
    @ApiModelProperty(value = "证件类型 12：营业执照/统一社会信用代码 45：民办非企业组织证件")
    @JSONField(name = "BussAuthType")
    private String bussAuthType;
    @ApiModelProperty(value = "证件号码 填写营业执照号或统一社会信用代码")
    @JSONField(name = "BussAuthNo")
    private String bussAuthNo;
    @ApiModelProperty(value = "营业执照有效期，如果营业执照证件照上传，则该字段必传")
    @JSONField(name = "BussAuthVld")
    private String bussAuthVld;
    @ApiModelProperty(value = "省份")
    @JSONField(name = "Province")
    private String province;
    @ApiModelProperty(value = "城市")
    @JSONField(name = "City")
    private String city;
    @ApiModelProperty(value = "区（县）")
    @JSONField(name = "District")
    private String district;
    @ApiModelProperty(value = "详细地址")
    @JSONField(name = "Address")
    private String address;

}
