package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 对账文件下载申请
 * <ant.mybank.bkmbp.stmt.fee.file.apply>
 **/
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkmbpStmtFeeFileApplyRequestModel extends RequestBody {


    private static final long serialVersionUID = 3167041743646941652L;

    /**
     * 合作方机构号（网商银行分配）。
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 单日期，格式为yyyyMMddhhmmss
     * 如明细账单类型则截取前14位，闭区间
     * 如日汇总类型则截取前8位，闭区间
     * 如月汇总类型则截取前6位，闭区间
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "StartTime")
    private String startTime;
    /**
     * 单日期，格式为yyyyMMddhhmmss
     * 如明细账单类型则截取前14位，闭区间
     * 如日汇总类型则截取前8位，闭区间
     * 如月汇总类型则截取前6位，闭区间
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "EndTime")
    private String endTime;

    /**
     * 外部交易号：
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutRequestNo")
    private String outRequestNo;

    /**
     * 下载账单类型
     **/
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "StmtType")
    private String stmtType;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getOutRequestNo() {
        return outRequestNo;
    }

    public void setOutRequestNo(String outRequestNo) {
        this.outRequestNo = outRequestNo;
    }

    public String getStmtType() {
        return stmtType;
    }

    public void setStmtType(String stmtType) {
        this.stmtType = stmtType;
    }
}