package com.zbkj.service.wangshang.api.domain.model;


import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;

/**
 * 充值保证金查询接口<ant.mybank.bkcloudfunds.vostro.charge.batchquery>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsVostroChargeBatchQueryResponseModel extends MybankObject {

    private static final long serialVersionUID = -8418511868657557L;
    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 查询商户号
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 充值保证金子户余额
     */
    @XmlElement(name = "ActualAmount")
    private String actualAmount;

    /**
     * 来账信息列表  JSON List & Base64 encode
     */
    @XmlElement(name = "VostroInfoList")
    private String vostroInfoList;

    /**
     * 当前页面
     */
    @XmlElement(name = "PageIndex")
    private String pageIndex;

    /**
     * 当前页面数
     */
    @XmlElement(name = "PageSize")
    private String pageSize;

    /**
     * 有没有下一页 true | false
     */
    @XmlElement(name = "HasNextPage")
    private boolean hasNextPage;

    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getActualAmount() {
        return actualAmount;
    }

    public void setActualAmount(String actualAmount) {
        this.actualAmount = actualAmount;
    }

    public String getVostroInfoList() {
        return vostroInfoList;
    }

    public void setVostroInfoList(String vostroInfoList) {
        this.vostroInfoList = vostroInfoList;
    }

    public String getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(String pageIndex) {
        this.pageIndex = pageIndex;
    }

    public String getPageSize() {
        return pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isHasNextPage() {
        return hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }
}