package com.zbkj.service.wangshang.api.domain.model;


import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;

/**
 * 查询电子业务凭证结果<ant.mybank.bkcloudfunds.electronicreceipt.query>@2.0.0
 * 响应模型
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsElectronicreceiptQueryResponseModel extends MybankObject {

    private static final long serialVersionUID = -9084556482174699412L;
    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 网商商户号
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 外部流水号
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 电子回单编号
     */
    @XmlElement(name = "ReceiptNo")
    private String receiptNo;

    /**
     * 状态
     * 01:处理中; 02:成功; 03:失败
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 电子回单CDN下载链接，有时效限制，超时可重新查询
     */
    @XmlElement(name = "PdfDownloadUrl")
    private String pdfDownloadUrl;

    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getReceiptNo() {
        return receiptNo;
    }

    public void setReceiptNo(String receiptNo) {
        this.receiptNo = receiptNo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPdfDownloadUrl() {
        return pdfDownloadUrl;
    }

    public void setPdfDownloadUrl(String pdfDownloadUrl) {
        this.pdfDownloadUrl = pdfDownloadUrl;
    }
}