package com.zbkj.service.wangshang.api;

public interface DefaultRequest<T extends MybankResponse> {

    /**
     * 获取API接口代码
     *
     * @return API代码
     */
    public String getApiFunction();

    /**
     * 获取当前API接口版本
     *
     * @return API版本
     */
    public String getApiVersion();

    /**
     * 设置当前API接口版本
     *
     * @param apiVersion API版本
     */
    public void setApiVersion(String apiVersion);

    /**
     * 获取当前API接口响应结果类型
     *
     * @return 响应类型
     */
    public Class<T> getResponseClass();
}