package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxUserOrgAuth;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxUserOrgAuthRequest;
import com.zbkj.service.dao.bcx.BcxUserOrgAuthDao;
import com.zbkj.service.service.UserService;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 用户企业认证表 服务实现类
 */
@Service
public class BcxUserOrgAuthServiceImpl extends ServiceImpl<BcxUserOrgAuthDao, BcxUserOrgAuth> implements BcxUserOrgAuthService {

    @Resource
    private BcxUserOrgAuthDao dao;
    @Resource
    private UserService userService;

    @Override
    public BcxUserOrgAuth queryById(Integer id) {
        return dao.selectById(id);
    }

    @Override
    public PageInfo<BcxUserOrgAuth> queryPagedList(BcxUserOrgAuth request,
                                                   PageParamRequest pageParamRequest) {
        LambdaQueryWrapper<BcxUserOrgAuth> lqw = new LambdaQueryWrapper<>();
        lqw.eq(BcxUserOrgAuth::getId, request.getId());
        Page<BcxUserOrgAuth> page = PageHelper.startPage(pageParamRequest.getPage(), pageParamRequest.getLimit());
        List<BcxUserOrgAuth> sources = dao.selectList(lqw);
        if (CollUtil.isEmpty(sources)) {
            return CommonPage.copyPageInfo(page, CollUtil.newArrayList());
        }
        List<BcxUserOrgAuth> result = transform2target(sources);
        return CommonPage.copyPageInfo(page, result);
    }

    private List<BcxUserOrgAuth> transform2target(List<BcxUserOrgAuth> sources) {
        List<BcxUserOrgAuth> result = new ArrayList<>();
        for (BcxUserOrgAuth source : sources) {
            BcxUserOrgAuth target = new BcxUserOrgAuth();
            BeanUtils.copyProperties(source, target);
            result.add(target);
        }
        return result;
    }

    @Override
    public Boolean create(BcxUserOrgAuthRequest bcxUserOrgAuth) {
        Integer userId = userService.getUserId();
        BcxUserOrgAuth exist = queryByUserId(userId);
        if (exist != null) {
            throw new CrmebException("已有认证企业，本次认证取消");
        }
        userService.checkValidateCode(bcxUserOrgAuth.getPhone(),bcxUserOrgAuth.getAuthCode());
        bcxUserOrgAuth.setUid(userId);
        BcxUserOrgAuth org = new BcxUserOrgAuth();
        BeanUtils.copyProperties(bcxUserOrgAuth, org);
        return save(org);
    }

    public Boolean update(BcxUserOrgAuth bcxUserOrgAuth) {
        return updateById(bcxUserOrgAuth);
    }

    public Boolean delete(Integer id) {
        return removeById(id);
    }

    @Override
    public BcxUserOrgAuth queryUserOrg() {
        Integer userId = userService.getUserIdException();
        return queryByUserId(userId);
    }

    private BcxUserOrgAuth queryByUserId(Integer userId) {
        LambdaQueryWrapper<BcxUserOrgAuth> lqw = new LambdaQueryWrapper<>();
        lqw.eq(BcxUserOrgAuth::getUid, userId);
        return dao.selectOne(lqw);
    }
}
