package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxPayOffline;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.bcx.BcxPayOfflineRequest;
import com.zbkj.common.response.bcx.BcxPayOfflineResponse;
import com.zbkj.service.dao.bcx.BcxPayOfflineDao;

import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.List;
/**
 * 订单线下支付 服务实现类
 */
@Service
public class BcxPayOfflineServiceImpl extends ServiceImpl<BcxPayOfflineDao, BcxPayOffline> implements BcxPayOfflineService {

    @Resource
    private BcxPayOfflineDao dao;

    @Override
    public BcxPayOffline queryByOrderNo(String orderNo){
        LambdaQueryWrapper<BcxPayOffline> query = new LambdaQueryWrapper<>();
        query.eq(BcxPayOffline::getOrderNo, orderNo);
        query.last("limit 1");
        BcxPayOffline offline = dao.selectOne(query);
        return offline;
    }

    @Override
    public PageInfo<BcxPayOfflineResponse> queryPagedList(BcxPayOfflineRequest request,
                                                          PageParamRequest pageParamRequest){
        LambdaQueryWrapper<BcxPayOffline> lqw = new LambdaQueryWrapper<>();
//        lqw.eq(BcxPayOffline::getId,request.getId());
        lqw.orderByDesc(BcxPayOffline::getId);
        Page<BcxPayOffline> page = PageHelper.startPage(pageParamRequest.getPage(), pageParamRequest.getLimit());
        List<BcxPayOffline> sources = dao.selectList(lqw);
        if (CollUtil.isEmpty(sources)) {
            return CommonPage.copyPageInfo(page, CollUtil.newArrayList());
        }
        List<BcxPayOfflineResponse> result = transform(sources);
        return CommonPage.copyPageInfo(page, result);
    }
    private List<BcxPayOfflineResponse> transform(List<BcxPayOffline> sources) {
        List<BcxPayOfflineResponse> result = new ArrayList<>();
        for (BcxPayOffline source : sources) {
            BcxPayOfflineResponse target = transform(source);
            result.add(target);
        }
        return result;
    }
    private BcxPayOfflineResponse transform(BcxPayOffline source) {
        BcxPayOfflineResponse target = new BcxPayOfflineResponse();
        BeanUtils.copyProperties(source, target);
        // set another perperties
        return target;
    }
}
